// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SecurityDevOps
{
    internal class GitHubOwnerOperationSource : IOperationSource<GitHubOwnerResource>
    {
        private readonly ArmClient _client;

        internal GitHubOwnerOperationSource(ArmClient client)
        {
            _client = client;
        }

        GitHubOwnerResource IOperationSource<GitHubOwnerResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GitHubOwnerData.DeserializeGitHubOwnerData(document.RootElement);
            return new GitHubOwnerResource(_client, data);
        }

        async ValueTask<GitHubOwnerResource> IOperationSource<GitHubOwnerResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GitHubOwnerData.DeserializeGitHubOwnerData(document.RootElement);
            return new GitHubOwnerResource(_client, data);
        }
    }
}
