// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SecurityDevOps
{
    internal class GitHubConnectorOperationSource : IOperationSource<GitHubConnectorResource>
    {
        private readonly ArmClient _client;

        internal GitHubConnectorOperationSource(ArmClient client)
        {
            _client = client;
        }

        GitHubConnectorResource IOperationSource<GitHubConnectorResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GitHubConnectorData.DeserializeGitHubConnectorData(document.RootElement);
            return new GitHubConnectorResource(_client, data);
        }

        async ValueTask<GitHubConnectorResource> IOperationSource<GitHubConnectorResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GitHubConnectorData.DeserializeGitHubConnectorData(document.RootElement);
            return new GitHubConnectorResource(_client, data);
        }
    }
}
