// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SecurityDevOps
{
    internal class AzureDevOpsRepoOperationSource : IOperationSource<AzureDevOpsRepoResource>
    {
        private readonly ArmClient _client;

        internal AzureDevOpsRepoOperationSource(ArmClient client)
        {
            _client = client;
        }

        AzureDevOpsRepoResource IOperationSource<AzureDevOpsRepoResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AzureDevOpsRepoData.DeserializeAzureDevOpsRepoData(document.RootElement);
            return new AzureDevOpsRepoResource(_client, data);
        }

        async ValueTask<AzureDevOpsRepoResource> IOperationSource<AzureDevOpsRepoResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AzureDevOpsRepoData.DeserializeAzureDevOpsRepoData(document.RootElement);
            return new AzureDevOpsRepoResource(_client, data);
        }
    }
}
