// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SecurityDevOps
{
    internal class AzureDevOpsProjectOperationSource : IOperationSource<AzureDevOpsProjectResource>
    {
        private readonly ArmClient _client;

        internal AzureDevOpsProjectOperationSource(ArmClient client)
        {
            _client = client;
        }

        AzureDevOpsProjectResource IOperationSource<AzureDevOpsProjectResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = AzureDevOpsProjectData.DeserializeAzureDevOpsProjectData(document.RootElement);
            return new AzureDevOpsProjectResource(_client, data);
        }

        async ValueTask<AzureDevOpsProjectResource> IOperationSource<AzureDevOpsProjectResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = AzureDevOpsProjectData.DeserializeAzureDevOpsProjectData(document.RootElement);
            return new AzureDevOpsProjectResource(_client, data);
        }
    }
}
