// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.SecurityDevOps.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableSecurityDevOpsArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableSecurityDevOpsArmClient"/> class for mocking. </summary>
        protected MockableSecurityDevOpsArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSecurityDevOpsArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSecurityDevOpsArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableSecurityDevOpsArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="AzureDevOpsConnectorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AzureDevOpsConnectorResource.CreateResourceIdentifier" /> to create an <see cref="AzureDevOpsConnectorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AzureDevOpsConnectorResource"/> object. </returns>
        public virtual AzureDevOpsConnectorResource GetAzureDevOpsConnectorResource(ResourceIdentifier id)
        {
            AzureDevOpsConnectorResource.ValidateResourceId(id);
            return new AzureDevOpsConnectorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AzureDevOpsRepoResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AzureDevOpsRepoResource.CreateResourceIdentifier" /> to create an <see cref="AzureDevOpsRepoResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AzureDevOpsRepoResource"/> object. </returns>
        public virtual AzureDevOpsRepoResource GetAzureDevOpsRepoResource(ResourceIdentifier id)
        {
            AzureDevOpsRepoResource.ValidateResourceId(id);
            return new AzureDevOpsRepoResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AzureDevOpsOrgResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AzureDevOpsOrgResource.CreateResourceIdentifier" /> to create an <see cref="AzureDevOpsOrgResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AzureDevOpsOrgResource"/> object. </returns>
        public virtual AzureDevOpsOrgResource GetAzureDevOpsOrgResource(ResourceIdentifier id)
        {
            AzureDevOpsOrgResource.ValidateResourceId(id);
            return new AzureDevOpsOrgResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AzureDevOpsProjectResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AzureDevOpsProjectResource.CreateResourceIdentifier" /> to create an <see cref="AzureDevOpsProjectResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AzureDevOpsProjectResource"/> object. </returns>
        public virtual AzureDevOpsProjectResource GetAzureDevOpsProjectResource(ResourceIdentifier id)
        {
            AzureDevOpsProjectResource.ValidateResourceId(id);
            return new AzureDevOpsProjectResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="GitHubConnectorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="GitHubConnectorResource.CreateResourceIdentifier" /> to create a <see cref="GitHubConnectorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="GitHubConnectorResource"/> object. </returns>
        public virtual GitHubConnectorResource GetGitHubConnectorResource(ResourceIdentifier id)
        {
            GitHubConnectorResource.ValidateResourceId(id);
            return new GitHubConnectorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="GitHubRepoResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="GitHubRepoResource.CreateResourceIdentifier" /> to create a <see cref="GitHubRepoResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="GitHubRepoResource"/> object. </returns>
        public virtual GitHubRepoResource GetGitHubRepoResource(ResourceIdentifier id)
        {
            GitHubRepoResource.ValidateResourceId(id);
            return new GitHubRepoResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="GitHubOwnerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="GitHubOwnerResource.CreateResourceIdentifier" /> to create a <see cref="GitHubOwnerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="GitHubOwnerResource"/> object. </returns>
        public virtual GitHubOwnerResource GetGitHubOwnerResource(ResourceIdentifier id)
        {
            GitHubOwnerResource.ValidateResourceId(id);
            return new GitHubOwnerResource(Client, id);
        }
    }
}
