// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityDevOps
{
    /// <summary>
    /// A class representing a collection of <see cref="AzureDevOpsProjectResource"/> and their operations.
    /// Each <see cref="AzureDevOpsProjectResource"/> in the collection will belong to the same instance of <see cref="AzureDevOpsOrgResource"/>.
    /// To get an <see cref="AzureDevOpsProjectCollection"/> instance call the GetAzureDevOpsProjects method from an instance of <see cref="AzureDevOpsOrgResource"/>.
    /// </summary>
    public partial class AzureDevOpsProjectCollection : ArmCollection, IEnumerable<AzureDevOpsProjectResource>, IAsyncEnumerable<AzureDevOpsProjectResource>
    {
        private readonly ClientDiagnostics _azureDevOpsProjectClientDiagnostics;
        private readonly AzureDevOpsProjectRestOperations _azureDevOpsProjectRestClient;

        /// <summary> Initializes a new instance of the <see cref="AzureDevOpsProjectCollection"/> class for mocking. </summary>
        protected AzureDevOpsProjectCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AzureDevOpsProjectCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AzureDevOpsProjectCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _azureDevOpsProjectClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityDevOps", AzureDevOpsProjectResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AzureDevOpsProjectResource.ResourceType, out string azureDevOpsProjectApiVersion);
            _azureDevOpsProjectRestClient = new AzureDevOpsProjectRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, azureDevOpsProjectApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != AzureDevOpsOrgResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, AzureDevOpsOrgResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates an Azure DevOps Project.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}/projects/{azureDevOpsProjectName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsProject_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureDevOpsProjectResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="azureDevOpsProjectName"> Name of the AzureDevOps Project. </param>
        /// <param name="data"> Azure DevOps Org resource payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureDevOpsProjectName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureDevOpsProjectName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AzureDevOpsProjectResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string azureDevOpsProjectName, AzureDevOpsProjectData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureDevOpsProjectName, nameof(azureDevOpsProjectName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _azureDevOpsProjectClientDiagnostics.CreateScope("AzureDevOpsProjectCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _azureDevOpsProjectRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, azureDevOpsProjectName, data, cancellationToken).ConfigureAwait(false);
                var operation = new SecurityDevOpsArmOperation<AzureDevOpsProjectResource>(new AzureDevOpsProjectOperationSource(Client), _azureDevOpsProjectClientDiagnostics, Pipeline, _azureDevOpsProjectRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, azureDevOpsProjectName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates an Azure DevOps Project.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}/projects/{azureDevOpsProjectName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsProject_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureDevOpsProjectResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="azureDevOpsProjectName"> Name of the AzureDevOps Project. </param>
        /// <param name="data"> Azure DevOps Org resource payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureDevOpsProjectName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureDevOpsProjectName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AzureDevOpsProjectResource> CreateOrUpdate(WaitUntil waitUntil, string azureDevOpsProjectName, AzureDevOpsProjectData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureDevOpsProjectName, nameof(azureDevOpsProjectName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _azureDevOpsProjectClientDiagnostics.CreateScope("AzureDevOpsProjectCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _azureDevOpsProjectRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, azureDevOpsProjectName, data, cancellationToken);
                var operation = new SecurityDevOpsArmOperation<AzureDevOpsProjectResource>(new AzureDevOpsProjectOperationSource(Client), _azureDevOpsProjectClientDiagnostics, Pipeline, _azureDevOpsProjectRestClient.CreateCreateOrUpdateRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, azureDevOpsProjectName, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns a monitored AzureDevOps Project resource for a given ID.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}/projects/{azureDevOpsProjectName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsProject_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureDevOpsProjectResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureDevOpsProjectName"> Name of the AzureDevOps Project. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureDevOpsProjectName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureDevOpsProjectName"/> is null. </exception>
        public virtual async Task<Response<AzureDevOpsProjectResource>> GetAsync(string azureDevOpsProjectName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureDevOpsProjectName, nameof(azureDevOpsProjectName));

            using var scope = _azureDevOpsProjectClientDiagnostics.CreateScope("AzureDevOpsProjectCollection.Get");
            scope.Start();
            try
            {
                var response = await _azureDevOpsProjectRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, azureDevOpsProjectName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AzureDevOpsProjectResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns a monitored AzureDevOps Project resource for a given ID.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}/projects/{azureDevOpsProjectName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsProject_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureDevOpsProjectResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureDevOpsProjectName"> Name of the AzureDevOps Project. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureDevOpsProjectName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureDevOpsProjectName"/> is null. </exception>
        public virtual Response<AzureDevOpsProjectResource> Get(string azureDevOpsProjectName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureDevOpsProjectName, nameof(azureDevOpsProjectName));

            using var scope = _azureDevOpsProjectClientDiagnostics.CreateScope("AzureDevOpsProjectCollection.Get");
            scope.Start();
            try
            {
                var response = _azureDevOpsProjectRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, azureDevOpsProjectName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AzureDevOpsProjectResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}/projects</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsProject_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureDevOpsProjectResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AzureDevOpsProjectResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AzureDevOpsProjectResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _azureDevOpsProjectRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _azureDevOpsProjectRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AzureDevOpsProjectResource(Client, AzureDevOpsProjectData.DeserializeAzureDevOpsProjectData(e)), _azureDevOpsProjectClientDiagnostics, Pipeline, "AzureDevOpsProjectCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}/projects</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsProject_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureDevOpsProjectResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AzureDevOpsProjectResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AzureDevOpsProjectResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _azureDevOpsProjectRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _azureDevOpsProjectRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AzureDevOpsProjectResource(Client, AzureDevOpsProjectData.DeserializeAzureDevOpsProjectData(e)), _azureDevOpsProjectClientDiagnostics, Pipeline, "AzureDevOpsProjectCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}/projects/{azureDevOpsProjectName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsProject_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureDevOpsProjectResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureDevOpsProjectName"> Name of the AzureDevOps Project. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureDevOpsProjectName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureDevOpsProjectName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string azureDevOpsProjectName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureDevOpsProjectName, nameof(azureDevOpsProjectName));

            using var scope = _azureDevOpsProjectClientDiagnostics.CreateScope("AzureDevOpsProjectCollection.Exists");
            scope.Start();
            try
            {
                var response = await _azureDevOpsProjectRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, azureDevOpsProjectName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}/projects/{azureDevOpsProjectName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsProject_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureDevOpsProjectResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureDevOpsProjectName"> Name of the AzureDevOps Project. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureDevOpsProjectName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureDevOpsProjectName"/> is null. </exception>
        public virtual Response<bool> Exists(string azureDevOpsProjectName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureDevOpsProjectName, nameof(azureDevOpsProjectName));

            using var scope = _azureDevOpsProjectClientDiagnostics.CreateScope("AzureDevOpsProjectCollection.Exists");
            scope.Start();
            try
            {
                var response = _azureDevOpsProjectRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, azureDevOpsProjectName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}/projects/{azureDevOpsProjectName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsProject_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureDevOpsProjectResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureDevOpsProjectName"> Name of the AzureDevOps Project. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureDevOpsProjectName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureDevOpsProjectName"/> is null. </exception>
        public virtual async Task<NullableResponse<AzureDevOpsProjectResource>> GetIfExistsAsync(string azureDevOpsProjectName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureDevOpsProjectName, nameof(azureDevOpsProjectName));

            using var scope = _azureDevOpsProjectClientDiagnostics.CreateScope("AzureDevOpsProjectCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _azureDevOpsProjectRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, azureDevOpsProjectName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AzureDevOpsProjectResource>(response.GetRawResponse());
                return Response.FromValue(new AzureDevOpsProjectResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SecurityDevOps/azureDevOpsConnectors/{azureDevOpsConnectorName}/orgs/{azureDevOpsOrgName}/projects/{azureDevOpsProjectName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>AzureDevOpsProject_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-09-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AzureDevOpsProjectResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="azureDevOpsProjectName"> Name of the AzureDevOps Project. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="azureDevOpsProjectName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="azureDevOpsProjectName"/> is null. </exception>
        public virtual NullableResponse<AzureDevOpsProjectResource> GetIfExists(string azureDevOpsProjectName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(azureDevOpsProjectName, nameof(azureDevOpsProjectName));

            using var scope = _azureDevOpsProjectClientDiagnostics.CreateScope("AzureDevOpsProjectCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _azureDevOpsProjectRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, azureDevOpsProjectName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AzureDevOpsProjectResource>(response.GetRawResponse());
                return Response.FromValue(new AzureDevOpsProjectResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AzureDevOpsProjectResource> IEnumerable<AzureDevOpsProjectResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AzureDevOpsProjectResource> IAsyncEnumerable<AzureDevOpsProjectResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
