// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityDevOps.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmSecurityDevOpsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="SecurityDevOps.AzureDevOpsConnectorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="SecurityDevOps.AzureDevOpsConnectorData"/> instance for mocking. </returns>
        public static AzureDevOpsConnectorData AzureDevOpsConnectorData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, AzureDevOpsConnectorProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new AzureDevOpsConnectorData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SecurityDevOps.AzureDevOpsRepoData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> AzureDevOps Repo properties. </param>
        /// <returns> A new <see cref="SecurityDevOps.AzureDevOpsRepoData"/> instance for mocking. </returns>
        public static AzureDevOpsRepoData AzureDevOpsRepoData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureDevOpsRepoProperties properties = null)
        {
            return new AzureDevOpsRepoData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AzureDevOpsConnectorStats"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="Models.AzureDevOpsConnectorStats"/> instance for mocking. </returns>
        public static AzureDevOpsConnectorStats AzureDevOpsConnectorStats(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureDevOpsConnectorStatsProperties properties = null)
        {
            return new AzureDevOpsConnectorStats(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SecurityDevOps.AzureDevOpsOrgData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> AzureDevOps Org properties. </param>
        /// <returns> A new <see cref="SecurityDevOps.AzureDevOpsOrgData"/> instance for mocking. </returns>
        public static AzureDevOpsOrgData AzureDevOpsOrgData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureDevOpsOrgProperties properties = null)
        {
            return new AzureDevOpsOrgData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SecurityDevOps.AzureDevOpsProjectData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> AzureDevOps Project properties. </param>
        /// <returns> A new <see cref="SecurityDevOps.AzureDevOpsProjectData"/> instance for mocking. </returns>
        public static AzureDevOpsProjectData AzureDevOpsProjectData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureDevOpsProjectProperties properties = null)
        {
            return new AzureDevOpsProjectData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SecurityDevOps.GitHubConnectorData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="properties"> Properties of the ARM resource for /subscriptions/xxx/resourceGroups/xxx/providers/Microsoft.SecurityDevOps/gitHubConnectors. </param>
        /// <returns> A new <see cref="SecurityDevOps.GitHubConnectorData"/> instance for mocking. </returns>
        public static GitHubConnectorData GitHubConnectorData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, GitHubConnectorProperties properties = null)
        {
            tags ??= new Dictionary<string, string>();

            return new GitHubConnectorData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SecurityDevOps.GitHubRepoData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> GitHub Repo properties. </param>
        /// <returns> A new <see cref="SecurityDevOps.GitHubRepoData"/> instance for mocking. </returns>
        public static GitHubRepoData GitHubRepoData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, GitHubRepoProperties properties = null)
        {
            return new GitHubRepoData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GitHubConnectorStats"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"></param>
        /// <returns> A new <see cref="Models.GitHubConnectorStats"/> instance for mocking. </returns>
        public static GitHubConnectorStats GitHubConnectorStats(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, GitHubConnectorStatsProperties properties = null)
        {
            return new GitHubConnectorStats(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SecurityDevOps.GitHubOwnerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> GitHub Repo Owner properties. </param>
        /// <returns> A new <see cref="SecurityDevOps.GitHubOwnerData"/> instance for mocking. </returns>
        public static GitHubOwnerData GitHubOwnerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, GitHubOwnerProperties properties = null)
        {
            return new GitHubOwnerData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }
    }
}
