// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityDevOps.Models;

namespace Azure.ResourceManager.SecurityDevOps.Samples
{
    public partial class Sample_AzureDevOpsRepoCollection
    {
        // AzureDevOpsRepo_List
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_AzureDevOpsRepoList()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsRepoList.json
            // this example is just showing the usage of "AzureDevOpsRepo_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsProjectResource created on azure
            // for more information of creating AzureDevOpsProjectResource, please refer to the document of AzureDevOpsProjectResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            string azureDevOpsOrgName = "myOrg";
            string azureDevOpsProjectName = "myProject";
            ResourceIdentifier azureDevOpsProjectResourceId = AzureDevOpsProjectResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName, azureDevOpsProjectName);
            AzureDevOpsProjectResource azureDevOpsProject = client.GetAzureDevOpsProjectResource(azureDevOpsProjectResourceId);

            // get the collection of this AzureDevOpsRepoResource
            AzureDevOpsRepoCollection collection = azureDevOpsProject.GetAzureDevOpsRepos();

            // invoke the operation and iterate over the result
            await foreach (AzureDevOpsRepoResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AzureDevOpsRepoData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // AzureDevOpsRepo_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AzureDevOpsRepoGet()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsRepoGet.json
            // this example is just showing the usage of "AzureDevOpsRepo_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsProjectResource created on azure
            // for more information of creating AzureDevOpsProjectResource, please refer to the document of AzureDevOpsProjectResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            string azureDevOpsOrgName = "myOrg";
            string azureDevOpsProjectName = "myProject";
            ResourceIdentifier azureDevOpsProjectResourceId = AzureDevOpsProjectResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName, azureDevOpsProjectName);
            AzureDevOpsProjectResource azureDevOpsProject = client.GetAzureDevOpsProjectResource(azureDevOpsProjectResourceId);

            // get the collection of this AzureDevOpsRepoResource
            AzureDevOpsRepoCollection collection = azureDevOpsProject.GetAzureDevOpsRepos();

            // invoke the operation
            string azureDevOpsRepoName = "myRepo";
            AzureDevOpsRepoResource result = await collection.GetAsync(azureDevOpsRepoName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureDevOpsRepoData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AzureDevOpsRepo_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_AzureDevOpsRepoGet()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsRepoGet.json
            // this example is just showing the usage of "AzureDevOpsRepo_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsProjectResource created on azure
            // for more information of creating AzureDevOpsProjectResource, please refer to the document of AzureDevOpsProjectResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            string azureDevOpsOrgName = "myOrg";
            string azureDevOpsProjectName = "myProject";
            ResourceIdentifier azureDevOpsProjectResourceId = AzureDevOpsProjectResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName, azureDevOpsProjectName);
            AzureDevOpsProjectResource azureDevOpsProject = client.GetAzureDevOpsProjectResource(azureDevOpsProjectResourceId);

            // get the collection of this AzureDevOpsRepoResource
            AzureDevOpsRepoCollection collection = azureDevOpsProject.GetAzureDevOpsRepos();

            // invoke the operation
            string azureDevOpsRepoName = "myRepo";
            bool result = await collection.ExistsAsync(azureDevOpsRepoName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // AzureDevOpsRepo_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_AzureDevOpsRepoGet()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsRepoGet.json
            // this example is just showing the usage of "AzureDevOpsRepo_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsProjectResource created on azure
            // for more information of creating AzureDevOpsProjectResource, please refer to the document of AzureDevOpsProjectResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            string azureDevOpsOrgName = "myOrg";
            string azureDevOpsProjectName = "myProject";
            ResourceIdentifier azureDevOpsProjectResourceId = AzureDevOpsProjectResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName, azureDevOpsProjectName);
            AzureDevOpsProjectResource azureDevOpsProject = client.GetAzureDevOpsProjectResource(azureDevOpsProjectResourceId);

            // get the collection of this AzureDevOpsRepoResource
            AzureDevOpsRepoCollection collection = azureDevOpsProject.GetAzureDevOpsRepos();

            // invoke the operation
            string azureDevOpsRepoName = "myRepo";
            NullableResponse<AzureDevOpsRepoResource> response = await collection.GetIfExistsAsync(azureDevOpsRepoName);
            AzureDevOpsRepoResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AzureDevOpsRepoData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // AzureDevOpsRepo_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_AzureDevOpsRepoCreateOrUpdate()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsRepoCreateOrUpdate.json
            // this example is just showing the usage of "AzureDevOpsRepo_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsProjectResource created on azure
            // for more information of creating AzureDevOpsProjectResource, please refer to the document of AzureDevOpsProjectResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            string azureDevOpsOrgName = "myOrg";
            string azureDevOpsProjectName = "myProject";
            ResourceIdentifier azureDevOpsProjectResourceId = AzureDevOpsProjectResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName, azureDevOpsProjectName);
            AzureDevOpsProjectResource azureDevOpsProject = client.GetAzureDevOpsProjectResource(azureDevOpsProjectResourceId);

            // get the collection of this AzureDevOpsRepoResource
            AzureDevOpsRepoCollection collection = azureDevOpsProject.GetAzureDevOpsRepos();

            // invoke the operation
            string azureDevOpsRepoName = "myRepo";
            AzureDevOpsRepoData data = new AzureDevOpsRepoData()
            {
                Properties = new AzureDevOpsRepoProperties()
                {
                    RepoId = "00000000-0000-0000-0000-000000000000",
                    RepoUri = new Uri("https://dev.azure.com/myOrg/myProject/_git/myRepo"),
                    ActionableRemediation = new ActionableRemediation()
                    {
                        State = ActionableRemediationState.Enabled,
                        SeverityLevels =
{
"High"
},
                        Categories =
{
ActionableRemediationRuleCategory.Secrets
},
                        BranchNames =
{
"main"
},
                    },
                },
            };
            ArmOperation<AzureDevOpsRepoResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, azureDevOpsRepoName, data);
            AzureDevOpsRepoResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureDevOpsRepoData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
