// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityDevOps.Models;

namespace Azure.ResourceManager.SecurityDevOps.Samples
{
    public partial class Sample_AzureDevOpsOrgResource
    {
        // AzureDevOpsOrg_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AzureDevOpsOrgGet()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsOrgGet.json
            // this example is just showing the usage of "AzureDevOpsOrg_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsOrgResource created on azure
            // for more information of creating AzureDevOpsOrgResource, please refer to the document of AzureDevOpsOrgResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            string azureDevOpsOrgName = "myOrg";
            ResourceIdentifier azureDevOpsOrgResourceId = AzureDevOpsOrgResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName);
            AzureDevOpsOrgResource azureDevOpsOrg = client.GetAzureDevOpsOrgResource(azureDevOpsOrgResourceId);

            // invoke the operation
            AzureDevOpsOrgResource result = await azureDevOpsOrg.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureDevOpsOrgData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AzureDevOpsOrg_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_AzureDevOpsOrgUpdate()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsOrgUpdate.json
            // this example is just showing the usage of "AzureDevOpsOrg_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsOrgResource created on azure
            // for more information of creating AzureDevOpsOrgResource, please refer to the document of AzureDevOpsOrgResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            string azureDevOpsOrgName = "myOrg";
            ResourceIdentifier azureDevOpsOrgResourceId = AzureDevOpsOrgResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName, azureDevOpsOrgName);
            AzureDevOpsOrgResource azureDevOpsOrg = client.GetAzureDevOpsOrgResource(azureDevOpsOrgResourceId);

            // invoke the operation
            AzureDevOpsOrgData data = new AzureDevOpsOrgData()
            {
                Properties = new AzureDevOpsOrgProperties()
                {
                    AutoDiscovery = AutoDiscovery.Disabled,
                },
            };
            ArmOperation<AzureDevOpsOrgResource> lro = await azureDevOpsOrg.UpdateAsync(WaitUntil.Completed, data);
            AzureDevOpsOrgResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureDevOpsOrgData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
