// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.SecurityDevOps.Models;

namespace Azure.ResourceManager.SecurityDevOps.Samples
{
    public partial class Sample_AzureDevOpsOrgCollection
    {
        // AzureDevOpsOrg_List
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_AzureDevOpsOrgList()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsOrgList.json
            // this example is just showing the usage of "AzureDevOpsOrg_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsConnectorResource created on azure
            // for more information of creating AzureDevOpsConnectorResource, please refer to the document of AzureDevOpsConnectorResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            ResourceIdentifier azureDevOpsConnectorResourceId = AzureDevOpsConnectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName);
            AzureDevOpsConnectorResource azureDevOpsConnector = client.GetAzureDevOpsConnectorResource(azureDevOpsConnectorResourceId);

            // get the collection of this AzureDevOpsOrgResource
            AzureDevOpsOrgCollection collection = azureDevOpsConnector.GetAzureDevOpsOrgs();

            // invoke the operation and iterate over the result
            await foreach (AzureDevOpsOrgResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AzureDevOpsOrgData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // AzureDevOpsOrg_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_AzureDevOpsOrgGet()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsOrgGet.json
            // this example is just showing the usage of "AzureDevOpsOrg_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsConnectorResource created on azure
            // for more information of creating AzureDevOpsConnectorResource, please refer to the document of AzureDevOpsConnectorResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            ResourceIdentifier azureDevOpsConnectorResourceId = AzureDevOpsConnectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName);
            AzureDevOpsConnectorResource azureDevOpsConnector = client.GetAzureDevOpsConnectorResource(azureDevOpsConnectorResourceId);

            // get the collection of this AzureDevOpsOrgResource
            AzureDevOpsOrgCollection collection = azureDevOpsConnector.GetAzureDevOpsOrgs();

            // invoke the operation
            string azureDevOpsOrgName = "myOrg";
            AzureDevOpsOrgResource result = await collection.GetAsync(azureDevOpsOrgName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureDevOpsOrgData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // AzureDevOpsOrg_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_AzureDevOpsOrgGet()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsOrgGet.json
            // this example is just showing the usage of "AzureDevOpsOrg_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsConnectorResource created on azure
            // for more information of creating AzureDevOpsConnectorResource, please refer to the document of AzureDevOpsConnectorResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            ResourceIdentifier azureDevOpsConnectorResourceId = AzureDevOpsConnectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName);
            AzureDevOpsConnectorResource azureDevOpsConnector = client.GetAzureDevOpsConnectorResource(azureDevOpsConnectorResourceId);

            // get the collection of this AzureDevOpsOrgResource
            AzureDevOpsOrgCollection collection = azureDevOpsConnector.GetAzureDevOpsOrgs();

            // invoke the operation
            string azureDevOpsOrgName = "myOrg";
            bool result = await collection.ExistsAsync(azureDevOpsOrgName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // AzureDevOpsOrg_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_AzureDevOpsOrgGet()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsOrgGet.json
            // this example is just showing the usage of "AzureDevOpsOrg_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsConnectorResource created on azure
            // for more information of creating AzureDevOpsConnectorResource, please refer to the document of AzureDevOpsConnectorResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            ResourceIdentifier azureDevOpsConnectorResourceId = AzureDevOpsConnectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName);
            AzureDevOpsConnectorResource azureDevOpsConnector = client.GetAzureDevOpsConnectorResource(azureDevOpsConnectorResourceId);

            // get the collection of this AzureDevOpsOrgResource
            AzureDevOpsOrgCollection collection = azureDevOpsConnector.GetAzureDevOpsOrgs();

            // invoke the operation
            string azureDevOpsOrgName = "myOrg";
            NullableResponse<AzureDevOpsOrgResource> response = await collection.GetIfExistsAsync(azureDevOpsOrgName);
            AzureDevOpsOrgResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                AzureDevOpsOrgData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // AzureDevOpsOrg_CreateOrUpdate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_AzureDevOpsOrgCreateOrUpdate()
        {
            // Generated from example definition: specification/securitydevops/resource-manager/Microsoft.SecurityDevOps/preview/2022-09-01-preview/examples/AzureDevOpsOrgCreateOrUpdate.json
            // this example is just showing the usage of "AzureDevOpsOrg_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this AzureDevOpsConnectorResource created on azure
            // for more information of creating AzureDevOpsConnectorResource, please refer to the document of AzureDevOpsConnectorResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "westusrg";
            string azureDevOpsConnectorName = "testconnector";
            ResourceIdentifier azureDevOpsConnectorResourceId = AzureDevOpsConnectorResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureDevOpsConnectorName);
            AzureDevOpsConnectorResource azureDevOpsConnector = client.GetAzureDevOpsConnectorResource(azureDevOpsConnectorResourceId);

            // get the collection of this AzureDevOpsOrgResource
            AzureDevOpsOrgCollection collection = azureDevOpsConnector.GetAzureDevOpsOrgs();

            // invoke the operation
            string azureDevOpsOrgName = "myOrg";
            AzureDevOpsOrgData data = new AzureDevOpsOrgData()
            {
                Properties = new AzureDevOpsOrgProperties()
                {
                    AutoDiscovery = AutoDiscovery.Disabled,
                },
            };
            ArmOperation<AzureDevOpsOrgResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, azureDevOpsOrgName, data);
            AzureDevOpsOrgResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            AzureDevOpsOrgData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
