// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A Class representing a SqlVulnerabilityAssessmentScan along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SqlVulnerabilityAssessmentScanResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSqlVulnerabilityAssessmentScanResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetSqlVulnerabilityAssessmentScan method.
    /// </summary>
    public partial class SqlVulnerabilityAssessmentScanResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SqlVulnerabilityAssessmentScanResource"/> instance. </summary>
        /// <param name="resourceId"> The resourceId. </param>
        /// <param name="scanId"> The scanId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string resourceId, string scanId)
        {
            var resourceId0 = $"{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}";
            return new ResourceIdentifier(resourceId0);
        }

        private readonly ClientDiagnostics _sqlVulnerabilityAssessmentScanClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentScansRestOperations _sqlVulnerabilityAssessmentScanRestClient;
        private readonly ClientDiagnostics _sqlVulnerabilityAssessmentScanResultsClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentScanResultsRestOperations _sqlVulnerabilityAssessmentScanResultsRestClient;
        private readonly SqlVulnerabilityAssessmentScanData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Security/sqlVulnerabilityAssessments/scans";

        /// <summary> Initializes a new instance of the <see cref="SqlVulnerabilityAssessmentScanResource"/> class for mocking. </summary>
        protected SqlVulnerabilityAssessmentScanResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlVulnerabilityAssessmentScanResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SqlVulnerabilityAssessmentScanResource(ArmClient client, SqlVulnerabilityAssessmentScanData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SqlVulnerabilityAssessmentScanResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SqlVulnerabilityAssessmentScanResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlVulnerabilityAssessmentScanClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string sqlVulnerabilityAssessmentScanApiVersion);
            _sqlVulnerabilityAssessmentScanRestClient = new SqlVulnerabilityAssessmentScansRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlVulnerabilityAssessmentScanApiVersion);
            _sqlVulnerabilityAssessmentScanResultsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _sqlVulnerabilityAssessmentScanResultsRestClient = new SqlVulnerabilityAssessmentScanResultsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SqlVulnerabilityAssessmentScanData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the scan details of a single scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlVulnerabilityAssessmentScanResource>> GetAsync(Guid workspaceId, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlVulnerabilityAssessmentScanClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentScanResource.Get");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentScanRestClient.GetAsync(Id.Parent.Parent, Id.Name, workspaceId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the scan details of a single scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlVulnerabilityAssessmentScanResource> Get(Guid workspaceId, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlVulnerabilityAssessmentScanClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentScanResource.Get");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentScanRestClient.Get(Id.Parent.Parent, Id.Name, workspaceId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the scan results of a single rule in a scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults/{scanResultId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResults_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanResultId"> The rule Id of the results. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanResultId"/> is null. </exception>
        public virtual async Task<Response<SqlVulnerabilityAssessmentScanResult>> GetSqlVulnerabilityAssessmentScanResultAsync(string scanResultId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var scope = _sqlVulnerabilityAssessmentScanResultsClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentScanResource.GetSqlVulnerabilityAssessmentScanResult");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentScanResultsRestClient.GetAsync(Id.Parent.Parent, Id.Name, scanResultId, workspaceId, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the scan results of a single rule in a scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults/{scanResultId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResults_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanResultId"> The rule Id of the results. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanResultId"/> is null. </exception>
        public virtual Response<SqlVulnerabilityAssessmentScanResult> GetSqlVulnerabilityAssessmentScanResult(string scanResultId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var scope = _sqlVulnerabilityAssessmentScanResultsClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentScanResource.GetSqlVulnerabilityAssessmentScanResult");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentScanResultsRestClient.Get(Id.Parent.Parent, Id.Name, scanResultId, workspaceId, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of scan results for a single scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResults_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlVulnerabilityAssessmentScanResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlVulnerabilityAssessmentScanResult> GetSqlVulnerabilityAssessmentScanResultsAsync(Guid workspaceId, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlVulnerabilityAssessmentScanResultsRestClient.CreateListRequest(Id.Parent.Parent, Id.Name, workspaceId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => SqlVulnerabilityAssessmentScanResult.DeserializeSqlVulnerabilityAssessmentScanResult(e), _sqlVulnerabilityAssessmentScanResultsClientDiagnostics, Pipeline, "SqlVulnerabilityAssessmentScanResource.GetSqlVulnerabilityAssessmentScanResults", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of scan results for a single scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}/scanResults</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResults_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlVulnerabilityAssessmentScanResult"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlVulnerabilityAssessmentScanResult> GetSqlVulnerabilityAssessmentScanResults(Guid workspaceId, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlVulnerabilityAssessmentScanResultsRestClient.CreateListRequest(Id.Parent.Parent, Id.Name, workspaceId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => SqlVulnerabilityAssessmentScanResult.DeserializeSqlVulnerabilityAssessmentScanResult(e), _sqlVulnerabilityAssessmentScanResultsClientDiagnostics, Pipeline, "SqlVulnerabilityAssessmentScanResource.GetSqlVulnerabilityAssessmentScanResults", "value", null, cancellationToken);
        }
    }
}
