// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlVulnerabilityAssessmentScanResource"/> and their operations.
    /// Each <see cref="SqlVulnerabilityAssessmentScanResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="SqlVulnerabilityAssessmentScanCollection"/> instance call the GetSqlVulnerabilityAssessmentScans method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class SqlVulnerabilityAssessmentScanCollection : ArmCollection
    {
        private readonly ClientDiagnostics _sqlVulnerabilityAssessmentScanClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentScansRestOperations _sqlVulnerabilityAssessmentScanRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlVulnerabilityAssessmentScanCollection"/> class for mocking. </summary>
        protected SqlVulnerabilityAssessmentScanCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlVulnerabilityAssessmentScanCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlVulnerabilityAssessmentScanCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlVulnerabilityAssessmentScanClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", SqlVulnerabilityAssessmentScanResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlVulnerabilityAssessmentScanResource.ResourceType, out string sqlVulnerabilityAssessmentScanApiVersion);
            _sqlVulnerabilityAssessmentScanRestClient = new SqlVulnerabilityAssessmentScansRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlVulnerabilityAssessmentScanApiVersion);
        }

        /// <summary>
        /// Gets the scan details of a single scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The scan Id. Type 'latest' to get the scan record for the latest scan. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<SqlVulnerabilityAssessmentScanResource>> GetAsync(string scanId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlVulnerabilityAssessmentScanClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentScanCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentScanRestClient.GetAsync(Id, scanId, workspaceId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the scan details of a single scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The scan Id. Type 'latest' to get the scan record for the latest scan. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<SqlVulnerabilityAssessmentScanResource> Get(string scanId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlVulnerabilityAssessmentScanClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentScanCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentScanRestClient.Get(Id, scanId, workspaceId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of scan records.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlVulnerabilityAssessmentScanResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlVulnerabilityAssessmentScanResource> GetAllAsync(Guid workspaceId, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlVulnerabilityAssessmentScanRestClient.CreateListRequest(Id, workspaceId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => new SqlVulnerabilityAssessmentScanResource(Client, SqlVulnerabilityAssessmentScanData.DeserializeSqlVulnerabilityAssessmentScanData(e)), _sqlVulnerabilityAssessmentScanClientDiagnostics, Pipeline, "SqlVulnerabilityAssessmentScanCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of scan records.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlVulnerabilityAssessmentScanResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlVulnerabilityAssessmentScanResource> GetAll(Guid workspaceId, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlVulnerabilityAssessmentScanRestClient.CreateListRequest(Id, workspaceId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => new SqlVulnerabilityAssessmentScanResource(Client, SqlVulnerabilityAssessmentScanData.DeserializeSqlVulnerabilityAssessmentScanData(e)), _sqlVulnerabilityAssessmentScanClientDiagnostics, Pipeline, "SqlVulnerabilityAssessmentScanCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The scan Id. Type 'latest' to get the scan record for the latest scan. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string scanId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlVulnerabilityAssessmentScanClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentScanCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentScanRestClient.GetAsync(Id, scanId, workspaceId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The scan Id. Type 'latest' to get the scan record for the latest scan. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<bool> Exists(string scanId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlVulnerabilityAssessmentScanClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentScanCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentScanRestClient.Get(Id, scanId, workspaceId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The scan Id. Type 'latest' to get the scan record for the latest scan. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<NullableResponse<SqlVulnerabilityAssessmentScanResource>> GetIfExistsAsync(string scanId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlVulnerabilityAssessmentScanClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentScanCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentScanRestClient.GetAsync(Id, scanId, workspaceId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlVulnerabilityAssessmentScanResource>(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The scan Id. Type 'latest' to get the scan record for the latest scan. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual NullableResponse<SqlVulnerabilityAssessmentScanResource> GetIfExists(string scanId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlVulnerabilityAssessmentScanClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentScanCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentScanRestClient.Get(Id, scanId, workspaceId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlVulnerabilityAssessmentScanResource>(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
