// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A Class representing a SqlVulnerabilityAssessmentBaselineRule along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSqlVulnerabilityAssessmentBaselineRuleResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetSqlVulnerabilityAssessmentBaselineRule method.
    /// </summary>
    public partial class SqlVulnerabilityAssessmentBaselineRuleResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/> instance. </summary>
        /// <param name="resourceId"> The resourceId. </param>
        /// <param name="ruleId"> The ruleId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string resourceId, string ruleId)
        {
            var resourceId0 = $"{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}";
            return new ResourceIdentifier(resourceId0);
        }

        private readonly ClientDiagnostics _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentBaselineRulesRestOperations _sqlVulnerabilityAssessmentBaselineRuleRestClient;
        private readonly SqlVulnerabilityAssessmentBaselineRuleData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Security/sqlVulnerabilityAssessments/baselineRules";

        /// <summary> Initializes a new instance of the <see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/> class for mocking. </summary>
        protected SqlVulnerabilityAssessmentBaselineRuleResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SqlVulnerabilityAssessmentBaselineRuleResource(ArmClient client, SqlVulnerabilityAssessmentBaselineRuleData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SqlVulnerabilityAssessmentBaselineRuleResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string sqlVulnerabilityAssessmentBaselineRuleApiVersion);
            _sqlVulnerabilityAssessmentBaselineRuleRestClient = new SqlVulnerabilityAssessmentBaselineRulesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlVulnerabilityAssessmentBaselineRuleApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SqlVulnerabilityAssessmentBaselineRuleData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the results for a given rule in the Baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlVulnerabilityAssessmentBaselineRuleResource>> GetAsync(Guid workspaceId, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleResource.Get");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentBaselineRuleRestClient.GetAsync(Id.Parent.Parent, Id.Name, workspaceId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentBaselineRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the results for a given rule in the Baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlVulnerabilityAssessmentBaselineRuleResource> Get(Guid workspaceId, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleResource.Get");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentBaselineRuleRestClient.Get(Id.Parent.Parent, Id.Name, workspaceId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentBaselineRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes a rule from the Baseline of a given database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleResource.Delete");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentBaselineRuleRestClient.DeleteAsync(Id.Parent.Parent, Id.Name, workspaceId, cancellationToken).ConfigureAwait(false);
                var uri = _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateDeleteRequestUri(Id.Parent.Parent, Id.Name, workspaceId);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Deletes a rule from the Baseline of a given database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleResource.Delete");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentBaselineRuleRestClient.Delete(Id.Parent.Parent, Id.Name, workspaceId, cancellationToken);
                var uri = _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateDeleteRequestUri(Id.Parent.Parent, Id.Name, workspaceId);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a Baseline for a rule in a database. Will overwrite any previously existing results.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="content"> The baseline results for this rule. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource>> UpdateAsync(WaitUntil waitUntil, Guid workspaceId, SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleResource.Update");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateOrUpdateAsync(Id.Parent.Parent, Id.Name, workspaceId, content, cancellationToken).ConfigureAwait(false);
                var uri = _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateCreateOrUpdateRequestUri(Id.Parent.Parent, Id.Name, workspaceId, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource>(Response.FromValue(new SqlVulnerabilityAssessmentBaselineRuleResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a Baseline for a rule in a database. Will overwrite any previously existing results.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="content"> The baseline results for this rule. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource> Update(WaitUntil waitUntil, Guid workspaceId, SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleResource.Update");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateOrUpdate(Id.Parent.Parent, Id.Name, workspaceId, content, cancellationToken);
                var uri = _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateCreateOrUpdateRequestUri(Id.Parent.Parent, Id.Name, workspaceId, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource>(Response.FromValue(new SqlVulnerabilityAssessmentBaselineRuleResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
