// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/> and their operations.
    /// Each <see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="SqlVulnerabilityAssessmentBaselineRuleCollection"/> instance call the GetSqlVulnerabilityAssessmentBaselineRules method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class SqlVulnerabilityAssessmentBaselineRuleCollection : ArmCollection
    {
        private readonly ClientDiagnostics _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentBaselineRulesRestOperations _sqlVulnerabilityAssessmentBaselineRuleRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlVulnerabilityAssessmentBaselineRuleCollection"/> class for mocking. </summary>
        protected SqlVulnerabilityAssessmentBaselineRuleCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlVulnerabilityAssessmentBaselineRuleCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlVulnerabilityAssessmentBaselineRuleCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", SqlVulnerabilityAssessmentBaselineRuleResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlVulnerabilityAssessmentBaselineRuleResource.ResourceType, out string sqlVulnerabilityAssessmentBaselineRuleApiVersion);
            _sqlVulnerabilityAssessmentBaselineRuleRestClient = new SqlVulnerabilityAssessmentBaselineRulesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlVulnerabilityAssessmentBaselineRuleApiVersion);
        }

        /// <summary>
        /// Creates a Baseline for a rule in a database. Will overwrite any previously existing results.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="content"> The baseline results for this rule. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> or <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string ruleId, Guid workspaceId, SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateOrUpdateAsync(Id, ruleId, workspaceId, content, cancellationToken).ConfigureAwait(false);
                var uri = _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateCreateOrUpdateRequestUri(Id, ruleId, workspaceId, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource>(Response.FromValue(new SqlVulnerabilityAssessmentBaselineRuleResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates a Baseline for a rule in a database. Will overwrite any previously existing results.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="content"> The baseline results for this rule. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> or <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource> CreateOrUpdate(WaitUntil waitUntil, string ruleId, Guid workspaceId, SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateOrUpdate(Id, ruleId, workspaceId, content, cancellationToken);
                var uri = _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateCreateOrUpdateRequestUri(Id, ruleId, workspaceId, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<SqlVulnerabilityAssessmentBaselineRuleResource>(Response.FromValue(new SqlVulnerabilityAssessmentBaselineRuleResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the results for a given rule in the Baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual async Task<Response<SqlVulnerabilityAssessmentBaselineRuleResource>> GetAsync(string ruleId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentBaselineRuleRestClient.GetAsync(Id, ruleId, workspaceId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentBaselineRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the results for a given rule in the Baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual Response<SqlVulnerabilityAssessmentBaselineRuleResource> Get(string ruleId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentBaselineRuleRestClient.Get(Id, ruleId, workspaceId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentBaselineRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the results for all rules in the Baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlVulnerabilityAssessmentBaselineRuleResource> GetAllAsync(Guid workspaceId, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateListRequest(Id, workspaceId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => new SqlVulnerabilityAssessmentBaselineRuleResource(Client, SqlVulnerabilityAssessmentBaselineRuleData.DeserializeSqlVulnerabilityAssessmentBaselineRuleData(e)), _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics, Pipeline, "SqlVulnerabilityAssessmentBaselineRuleCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets the results for all rules in the Baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlVulnerabilityAssessmentBaselineRuleResource> GetAll(Guid workspaceId, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlVulnerabilityAssessmentBaselineRuleRestClient.CreateListRequest(Id, workspaceId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => new SqlVulnerabilityAssessmentBaselineRuleResource(Client, SqlVulnerabilityAssessmentBaselineRuleData.DeserializeSqlVulnerabilityAssessmentBaselineRuleData(e)), _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics, Pipeline, "SqlVulnerabilityAssessmentBaselineRuleCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string ruleId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentBaselineRuleRestClient.GetAsync(Id, ruleId, workspaceId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual Response<bool> Exists(string ruleId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentBaselineRuleRestClient.Get(Id, ruleId, workspaceId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual async Task<NullableResponse<SqlVulnerabilityAssessmentBaselineRuleResource>> GetIfExistsAsync(string ruleId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentBaselineRuleRestClient.GetAsync(Id, ruleId, workspaceId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlVulnerabilityAssessmentBaselineRuleResource>(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentBaselineRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselineRules_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-02-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual NullableResponse<SqlVulnerabilityAssessmentBaselineRuleResource> GetIfExists(string ruleId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlVulnerabilityAssessmentBaselineRuleClientDiagnostics.CreateScope("SqlVulnerabilityAssessmentBaselineRuleCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentBaselineRuleRestClient.Get(Id, ruleId, workspaceId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlVulnerabilityAssessmentBaselineRuleResource>(response.GetRawResponse());
                return Response.FromValue(new SqlVulnerabilityAssessmentBaselineRuleResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
