// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing the SoftwareInventory data model.
    /// Represents a software data
    /// </summary>
    public partial class SoftwareInventoryData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SoftwareInventoryData"/>. </summary>
        public SoftwareInventoryData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SoftwareInventoryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="deviceId"> Unique identifier for the virtual machine in the service. </param>
        /// <param name="osPlatform"> Platform of the operating system running on the device. </param>
        /// <param name="vendor"> Name of the software vendor. </param>
        /// <param name="softwareName"> Name of the software product. </param>
        /// <param name="version"> Version number of the software product. </param>
        /// <param name="endOfSupportStatus"> End of support status. </param>
        /// <param name="endOfSupportDate"> The end of support date in case the product is upcoming end of support. </param>
        /// <param name="numberOfKnownVulnerabilities"> Number of weaknesses. </param>
        /// <param name="firstSeenOn"> First time that the software was seen in the device. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SoftwareInventoryData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string deviceId, string osPlatform, string vendor, string softwareName, string version, EndOfSupportStatus? endOfSupportStatus, string endOfSupportDate, int? numberOfKnownVulnerabilities, DateTimeOffset? firstSeenOn, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DeviceId = deviceId;
            OSPlatform = osPlatform;
            Vendor = vendor;
            SoftwareName = softwareName;
            Version = version;
            EndOfSupportStatus = endOfSupportStatus;
            EndOfSupportDate = endOfSupportDate;
            NumberOfKnownVulnerabilities = numberOfKnownVulnerabilities;
            FirstSeenOn = firstSeenOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Unique identifier for the virtual machine in the service. </summary>
        public string DeviceId { get; set; }
        /// <summary> Platform of the operating system running on the device. </summary>
        public string OSPlatform { get; set; }
        /// <summary> Name of the software vendor. </summary>
        public string Vendor { get; set; }
        /// <summary> Name of the software product. </summary>
        public string SoftwareName { get; set; }
        /// <summary> Version number of the software product. </summary>
        public string Version { get; set; }
        /// <summary> End of support status. </summary>
        public EndOfSupportStatus? EndOfSupportStatus { get; set; }
        /// <summary> The end of support date in case the product is upcoming end of support. </summary>
        public string EndOfSupportDate { get; set; }
        /// <summary> Number of weaknesses. </summary>
        public int? NumberOfKnownVulnerabilities { get; set; }
        /// <summary> First time that the software was seen in the device. </summary>
        public DateTimeOffset? FirstSeenOn { get; set; }
    }
}
