// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="SoftwareInventoryResource"/> and their operations.
    /// Each <see cref="SoftwareInventoryResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="SoftwareInventoryCollection"/> instance call the GetSoftwareInventories method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class SoftwareInventoryCollection : ArmCollection, IEnumerable<SoftwareInventoryResource>, IAsyncEnumerable<SoftwareInventoryResource>
    {
        private readonly ClientDiagnostics _softwareInventoryClientDiagnostics;
        private readonly SoftwareInventoriesRestOperations _softwareInventoryRestClient;
        private readonly string _resourceNamespace;
        private readonly string _resourceType;
        private readonly string _resourceName;

        /// <summary> Initializes a new instance of the <see cref="SoftwareInventoryCollection"/> class for mocking. </summary>
        protected SoftwareInventoryCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SoftwareInventoryCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="resourceNamespace"> The namespace of the resource. </param>
        /// <param name="resourceType"> The type of the resource. </param>
        /// <param name="resourceName"> Name of the resource. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceNamespace"/>, <paramref name="resourceType"/> or <paramref name="resourceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="resourceNamespace"/>, <paramref name="resourceType"/> or <paramref name="resourceName"/> is an empty string, and was expected to be non-empty. </exception>
        internal SoftwareInventoryCollection(ArmClient client, ResourceIdentifier id, string resourceNamespace, string resourceType, string resourceName) : base(client, id)
        {
            _resourceNamespace = resourceNamespace;
            _resourceType = resourceType;
            _resourceName = resourceName;
            _softwareInventoryClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", SoftwareInventoryResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SoftwareInventoryResource.ResourceType, out string softwareInventoryApiVersion);
            _softwareInventoryRestClient = new SoftwareInventoriesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, softwareInventoryApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a single software data of the virtual machine.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/softwareInventories/{softwareName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SoftwareInventories_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SoftwareInventoryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="softwareName"> Name of the installed software. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="softwareName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="softwareName"/> is null. </exception>
        public virtual async Task<Response<SoftwareInventoryResource>> GetAsync(string softwareName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(softwareName, nameof(softwareName));

            using var scope = _softwareInventoryClientDiagnostics.CreateScope("SoftwareInventoryCollection.Get");
            scope.Start();
            try
            {
                var response = await _softwareInventoryRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, softwareName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SoftwareInventoryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a single software data of the virtual machine.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/softwareInventories/{softwareName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SoftwareInventories_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SoftwareInventoryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="softwareName"> Name of the installed software. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="softwareName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="softwareName"/> is null. </exception>
        public virtual Response<SoftwareInventoryResource> Get(string softwareName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(softwareName, nameof(softwareName));

            using var scope = _softwareInventoryClientDiagnostics.CreateScope("SoftwareInventoryCollection.Get");
            scope.Start();
            try
            {
                var response = _softwareInventoryRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, softwareName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SoftwareInventoryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the software inventory of the virtual machine.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/softwareInventories</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SoftwareInventories_ListByExtendedResource</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SoftwareInventoryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SoftwareInventoryResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SoftwareInventoryResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _softwareInventoryRestClient.CreateListByExtendedResourceRequest(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _softwareInventoryRestClient.CreateListByExtendedResourceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SoftwareInventoryResource(Client, SoftwareInventoryData.DeserializeSoftwareInventoryData(e)), _softwareInventoryClientDiagnostics, Pipeline, "SoftwareInventoryCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets the software inventory of the virtual machine.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/softwareInventories</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SoftwareInventories_ListByExtendedResource</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SoftwareInventoryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SoftwareInventoryResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SoftwareInventoryResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _softwareInventoryRestClient.CreateListByExtendedResourceRequest(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _softwareInventoryRestClient.CreateListByExtendedResourceNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SoftwareInventoryResource(Client, SoftwareInventoryData.DeserializeSoftwareInventoryData(e)), _softwareInventoryClientDiagnostics, Pipeline, "SoftwareInventoryCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/softwareInventories/{softwareName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SoftwareInventories_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SoftwareInventoryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="softwareName"> Name of the installed software. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="softwareName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="softwareName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string softwareName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(softwareName, nameof(softwareName));

            using var scope = _softwareInventoryClientDiagnostics.CreateScope("SoftwareInventoryCollection.Exists");
            scope.Start();
            try
            {
                var response = await _softwareInventoryRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, softwareName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/softwareInventories/{softwareName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SoftwareInventories_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SoftwareInventoryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="softwareName"> Name of the installed software. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="softwareName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="softwareName"/> is null. </exception>
        public virtual Response<bool> Exists(string softwareName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(softwareName, nameof(softwareName));

            using var scope = _softwareInventoryClientDiagnostics.CreateScope("SoftwareInventoryCollection.Exists");
            scope.Start();
            try
            {
                var response = _softwareInventoryRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, softwareName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/softwareInventories/{softwareName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SoftwareInventories_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SoftwareInventoryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="softwareName"> Name of the installed software. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="softwareName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="softwareName"/> is null. </exception>
        public virtual async Task<NullableResponse<SoftwareInventoryResource>> GetIfExistsAsync(string softwareName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(softwareName, nameof(softwareName));

            using var scope = _softwareInventoryClientDiagnostics.CreateScope("SoftwareInventoryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _softwareInventoryRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, softwareName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SoftwareInventoryResource>(response.GetRawResponse());
                return Response.FromValue(new SoftwareInventoryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/softwareInventories/{softwareName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SoftwareInventories_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SoftwareInventoryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="softwareName"> Name of the installed software. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="softwareName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="softwareName"/> is null. </exception>
        public virtual NullableResponse<SoftwareInventoryResource> GetIfExists(string softwareName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(softwareName, nameof(softwareName));

            using var scope = _softwareInventoryClientDiagnostics.CreateScope("SoftwareInventoryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _softwareInventoryRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, softwareName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SoftwareInventoryResource>(response.GetRawResponse());
                return Response.FromValue(new SoftwareInventoryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SoftwareInventoryResource> IEnumerable<SoftwareInventoryResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SoftwareInventoryResource> IAsyncEnumerable<SoftwareInventoryResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
