// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A Class representing a ServerVulnerabilityAssessmentsSetting along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="ServerVulnerabilityAssessmentsSettingResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetServerVulnerabilityAssessmentsSettingResource method.
    /// Otherwise you can get one from its parent resource <see cref="SubscriptionResource"/> using the GetServerVulnerabilityAssessmentsSetting method.
    /// </summary>
    public partial class ServerVulnerabilityAssessmentsSettingResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="ServerVulnerabilityAssessmentsSettingResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="settingKind"> The settingKind. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, ServerVulnerabilityAssessmentsSettingKindName settingKind)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _serverVulnerabilityAssessmentsSettingClientDiagnostics;
        private readonly ServerVulnerabilityAssessmentsSettingsRestOperations _serverVulnerabilityAssessmentsSettingRestClient;
        private readonly ServerVulnerabilityAssessmentsSettingData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Security/serverVulnerabilityAssessmentsSettings";

        /// <summary> Initializes a new instance of the <see cref="ServerVulnerabilityAssessmentsSettingResource"/> class for mocking. </summary>
        protected ServerVulnerabilityAssessmentsSettingResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ServerVulnerabilityAssessmentsSettingResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal ServerVulnerabilityAssessmentsSettingResource(ArmClient client, ServerVulnerabilityAssessmentsSettingData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="ServerVulnerabilityAssessmentsSettingResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal ServerVulnerabilityAssessmentsSettingResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _serverVulnerabilityAssessmentsSettingClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string serverVulnerabilityAssessmentsSettingApiVersion);
            _serverVulnerabilityAssessmentsSettingRestClient = new ServerVulnerabilityAssessmentsSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, serverVulnerabilityAssessmentsSettingApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual ServerVulnerabilityAssessmentsSettingData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a server vulnerability assessments setting of the requested kind, that is set on the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ServerVulnerabilityAssessmentsSettingResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingResource.Get");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentsSettingRestClient.GetAsync(Id.SubscriptionId, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServerVulnerabilityAssessmentsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a server vulnerability assessments setting of the requested kind, that is set on the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ServerVulnerabilityAssessmentsSettingResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingResource.Get");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentsSettingRestClient.Get(Id.SubscriptionId, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServerVulnerabilityAssessmentsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete the server vulnerability assessments setting of the requested kind from the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingResource.Delete");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentsSettingRestClient.DeleteAsync(Id.SubscriptionId, Id.Name, cancellationToken).ConfigureAwait(false);
                var uri = _serverVulnerabilityAssessmentsSettingRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.Name);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Delete the server vulnerability assessments setting of the requested kind from the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingResource.Delete");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentsSettingRestClient.Delete(Id.SubscriptionId, Id.Name, cancellationToken);
                var uri = _serverVulnerabilityAssessmentsSettingRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.Name);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update a server vulnerability assessments setting of the requested kind on the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> A server vulnerability assessments setting over a predefined scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ServerVulnerabilityAssessmentsSettingResource>> UpdateAsync(WaitUntil waitUntil, ServerVulnerabilityAssessmentsSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingResource.Update");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentsSettingRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.Name, data, cancellationToken).ConfigureAwait(false);
                var uri = _serverVulnerabilityAssessmentsSettingRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.Name, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<ServerVulnerabilityAssessmentsSettingResource>(Response.FromValue(new ServerVulnerabilityAssessmentsSettingResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update a server vulnerability assessments setting of the requested kind on the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> A server vulnerability assessments setting over a predefined scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ServerVulnerabilityAssessmentsSettingResource> Update(WaitUntil waitUntil, ServerVulnerabilityAssessmentsSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingResource.Update");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentsSettingRestClient.CreateOrUpdate(Id.SubscriptionId, Id.Name, data, cancellationToken);
                var uri = _serverVulnerabilityAssessmentsSettingRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.Name, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<ServerVulnerabilityAssessmentsSettingResource>(Response.FromValue(new ServerVulnerabilityAssessmentsSettingResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
