// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    [PersistableModelProxy(typeof(UnknownServerVulnerabilityAssessmentsSetting))]
    public partial class ServerVulnerabilityAssessmentsSettingData : IUtf8JsonSerializable, IJsonModel<ServerVulnerabilityAssessmentsSettingData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServerVulnerabilityAssessmentsSettingData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServerVulnerabilityAssessmentsSettingData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerVulnerabilityAssessmentsSettingData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerVulnerabilityAssessmentsSettingData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("kind"u8);
            writer.WriteStringValue(Kind.ToString());
        }

        ServerVulnerabilityAssessmentsSettingData IJsonModel<ServerVulnerabilityAssessmentsSettingData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerVulnerabilityAssessmentsSettingData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerVulnerabilityAssessmentsSettingData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServerVulnerabilityAssessmentsSettingData(document.RootElement, options);
        }

        internal static ServerVulnerabilityAssessmentsSettingData DeserializeServerVulnerabilityAssessmentsSettingData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("kind", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "AzureServersSetting": return AzureServersSetting.DeserializeAzureServersSetting(element, options);
                }
            }
            return UnknownServerVulnerabilityAssessmentsSetting.DeserializeUnknownServerVulnerabilityAssessmentsSetting(element, options);
        }

        BinaryData IPersistableModel<ServerVulnerabilityAssessmentsSettingData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerVulnerabilityAssessmentsSettingData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServerVulnerabilityAssessmentsSettingData)} does not support writing '{options.Format}' format.");
            }
        }

        ServerVulnerabilityAssessmentsSettingData IPersistableModel<ServerVulnerabilityAssessmentsSettingData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerVulnerabilityAssessmentsSettingData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServerVulnerabilityAssessmentsSettingData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServerVulnerabilityAssessmentsSettingData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServerVulnerabilityAssessmentsSettingData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
