// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="ServerVulnerabilityAssessmentsSettingResource"/> and their operations.
    /// Each <see cref="ServerVulnerabilityAssessmentsSettingResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>.
    /// To get a <see cref="ServerVulnerabilityAssessmentsSettingCollection"/> instance call the GetServerVulnerabilityAssessmentsSettings method from an instance of <see cref="SubscriptionResource"/>.
    /// </summary>
    public partial class ServerVulnerabilityAssessmentsSettingCollection : ArmCollection, IEnumerable<ServerVulnerabilityAssessmentsSettingResource>, IAsyncEnumerable<ServerVulnerabilityAssessmentsSettingResource>
    {
        private readonly ClientDiagnostics _serverVulnerabilityAssessmentsSettingClientDiagnostics;
        private readonly ServerVulnerabilityAssessmentsSettingsRestOperations _serverVulnerabilityAssessmentsSettingRestClient;

        /// <summary> Initializes a new instance of the <see cref="ServerVulnerabilityAssessmentsSettingCollection"/> class for mocking. </summary>
        protected ServerVulnerabilityAssessmentsSettingCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ServerVulnerabilityAssessmentsSettingCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal ServerVulnerabilityAssessmentsSettingCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _serverVulnerabilityAssessmentsSettingClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", ServerVulnerabilityAssessmentsSettingResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ServerVulnerabilityAssessmentsSettingResource.ResourceType, out string serverVulnerabilityAssessmentsSettingApiVersion);
            _serverVulnerabilityAssessmentsSettingRestClient = new ServerVulnerabilityAssessmentsSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, serverVulnerabilityAssessmentsSettingApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SubscriptionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SubscriptionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create or update a server vulnerability assessments setting of the requested kind on the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="settingKind"> The kind of the server vulnerability assessments setting. </param>
        /// <param name="data"> A server vulnerability assessments setting over a predefined scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<ServerVulnerabilityAssessmentsSettingResource>> CreateOrUpdateAsync(WaitUntil waitUntil, ServerVulnerabilityAssessmentsSettingKindName settingKind, ServerVulnerabilityAssessmentsSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentsSettingRestClient.CreateOrUpdateAsync(Id.SubscriptionId, settingKind, data, cancellationToken).ConfigureAwait(false);
                var uri = _serverVulnerabilityAssessmentsSettingRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, settingKind, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<ServerVulnerabilityAssessmentsSettingResource>(Response.FromValue(new ServerVulnerabilityAssessmentsSettingResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update a server vulnerability assessments setting of the requested kind on the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="settingKind"> The kind of the server vulnerability assessments setting. </param>
        /// <param name="data"> A server vulnerability assessments setting over a predefined scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<ServerVulnerabilityAssessmentsSettingResource> CreateOrUpdate(WaitUntil waitUntil, ServerVulnerabilityAssessmentsSettingKindName settingKind, ServerVulnerabilityAssessmentsSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentsSettingRestClient.CreateOrUpdate(Id.SubscriptionId, settingKind, data, cancellationToken);
                var uri = _serverVulnerabilityAssessmentsSettingRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, settingKind, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<ServerVulnerabilityAssessmentsSettingResource>(Response.FromValue(new ServerVulnerabilityAssessmentsSettingResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a server vulnerability assessments setting of the requested kind, that is set on the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingKind"> The kind of the server vulnerability assessments setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ServerVulnerabilityAssessmentsSettingResource>> GetAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind, CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingCollection.Get");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentsSettingRestClient.GetAsync(Id.SubscriptionId, settingKind, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServerVulnerabilityAssessmentsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a server vulnerability assessments setting of the requested kind, that is set on the subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingKind"> The kind of the server vulnerability assessments setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ServerVulnerabilityAssessmentsSettingResource> Get(ServerVulnerabilityAssessmentsSettingKindName settingKind, CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingCollection.Get");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentsSettingRestClient.Get(Id.SubscriptionId, settingKind, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServerVulnerabilityAssessmentsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a list of all the server vulnerability assessments settings over a subscription level scope
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ServerVulnerabilityAssessmentsSettingResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ServerVulnerabilityAssessmentsSettingResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serverVulnerabilityAssessmentsSettingRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serverVulnerabilityAssessmentsSettingRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new ServerVulnerabilityAssessmentsSettingResource(Client, ServerVulnerabilityAssessmentsSettingData.DeserializeServerVulnerabilityAssessmentsSettingData(e)), _serverVulnerabilityAssessmentsSettingClientDiagnostics, Pipeline, "ServerVulnerabilityAssessmentsSettingCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Get a list of all the server vulnerability assessments settings over a subscription level scope
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_ListBySubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ServerVulnerabilityAssessmentsSettingResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ServerVulnerabilityAssessmentsSettingResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serverVulnerabilityAssessmentsSettingRestClient.CreateListBySubscriptionRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _serverVulnerabilityAssessmentsSettingRestClient.CreateListBySubscriptionNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new ServerVulnerabilityAssessmentsSettingResource(Client, ServerVulnerabilityAssessmentsSettingData.DeserializeServerVulnerabilityAssessmentsSettingData(e)), _serverVulnerabilityAssessmentsSettingClientDiagnostics, Pipeline, "ServerVulnerabilityAssessmentsSettingCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingKind"> The kind of the server vulnerability assessments setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind, CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingCollection.Exists");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentsSettingRestClient.GetAsync(Id.SubscriptionId, settingKind, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingKind"> The kind of the server vulnerability assessments setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(ServerVulnerabilityAssessmentsSettingKindName settingKind, CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingCollection.Exists");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentsSettingRestClient.Get(Id.SubscriptionId, settingKind, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingKind"> The kind of the server vulnerability assessments setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<ServerVulnerabilityAssessmentsSettingResource>> GetIfExistsAsync(ServerVulnerabilityAssessmentsSettingKindName settingKind, CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentsSettingRestClient.GetAsync(Id.SubscriptionId, settingKind, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ServerVulnerabilityAssessmentsSettingResource>(response.GetRawResponse());
                return Response.FromValue(new ServerVulnerabilityAssessmentsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/serverVulnerabilityAssessmentsSettings/{settingKind}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingKind"> The kind of the server vulnerability assessments setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<ServerVulnerabilityAssessmentsSettingResource> GetIfExists(ServerVulnerabilityAssessmentsSettingKindName settingKind, CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentsSettingClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentsSettingCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentsSettingRestClient.Get(Id.SubscriptionId, settingKind, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ServerVulnerabilityAssessmentsSettingResource>(response.GetRawResponse());
                return Response.FromValue(new ServerVulnerabilityAssessmentsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ServerVulnerabilityAssessmentsSettingResource> IEnumerable<ServerVulnerabilityAssessmentsSettingResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ServerVulnerabilityAssessmentsSettingResource> IAsyncEnumerable<ServerVulnerabilityAssessmentsSettingResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
