// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="ServerVulnerabilityAssessmentResource"/> and their operations.
    /// Each <see cref="ServerVulnerabilityAssessmentResource"/> in the collection will belong to the same instance of <see cref="ResourceGroupResource"/>.
    /// To get a <see cref="ServerVulnerabilityAssessmentCollection"/> instance call the GetServerVulnerabilityAssessments method from an instance of <see cref="ResourceGroupResource"/>.
    /// </summary>
    public partial class ServerVulnerabilityAssessmentCollection : ArmCollection, IEnumerable<ServerVulnerabilityAssessmentResource>, IAsyncEnumerable<ServerVulnerabilityAssessmentResource>
    {
        private readonly ClientDiagnostics _serverVulnerabilityAssessmentClientDiagnostics;
        private readonly ServerVulnerabilityAssessmentRestOperations _serverVulnerabilityAssessmentRestClient;
        private readonly string _resourceNamespace;
        private readonly string _resourceType;
        private readonly string _resourceName;

        /// <summary> Initializes a new instance of the <see cref="ServerVulnerabilityAssessmentCollection"/> class for mocking. </summary>
        protected ServerVulnerabilityAssessmentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="ServerVulnerabilityAssessmentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="resourceNamespace"> The Namespace of the resource. </param>
        /// <param name="resourceType"> The type of the resource. </param>
        /// <param name="resourceName"> Name of the resource. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceNamespace"/>, <paramref name="resourceType"/> or <paramref name="resourceName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="resourceNamespace"/>, <paramref name="resourceType"/> or <paramref name="resourceName"/> is an empty string, and was expected to be non-empty. </exception>
        internal ServerVulnerabilityAssessmentCollection(ArmClient client, ResourceIdentifier id, string resourceNamespace, string resourceType, string resourceName) : base(client, id)
        {
            _resourceNamespace = resourceNamespace;
            _resourceType = resourceType;
            _resourceName = resourceName;
            _serverVulnerabilityAssessmentClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", ServerVulnerabilityAssessmentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ServerVulnerabilityAssessmentResource.ResourceType, out string serverVulnerabilityAssessmentApiVersion);
            _serverVulnerabilityAssessmentRestClient = new ServerVulnerabilityAssessmentRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, serverVulnerabilityAssessmentApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceGroupResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceGroupResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creating a server vulnerability assessment on a resource, which will onboard a resource for having a vulnerability assessment on it
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessment_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation<ServerVulnerabilityAssessmentResource>> CreateOrUpdateAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, cancellationToken).ConfigureAwait(false);
                var uri = _serverVulnerabilityAssessmentRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<ServerVulnerabilityAssessmentResource>(Response.FromValue(new ServerVulnerabilityAssessmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creating a server vulnerability assessment on a resource, which will onboard a resource for having a vulnerability assessment on it
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessment_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation<ServerVulnerabilityAssessmentResource> CreateOrUpdate(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, cancellationToken);
                var uri = _serverVulnerabilityAssessmentRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<ServerVulnerabilityAssessmentResource>(Response.FromValue(new ServerVulnerabilityAssessmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a server vulnerability assessment onboarding statuses on a given resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessment_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<ServerVulnerabilityAssessmentResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentCollection.Get");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServerVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a server vulnerability assessment onboarding statuses on a given resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessment_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<ServerVulnerabilityAssessmentResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentCollection.Get");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new ServerVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of server vulnerability assessment onboarding statuses on a given resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessment_ListByExtendedResource</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="ServerVulnerabilityAssessmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<ServerVulnerabilityAssessmentResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serverVulnerabilityAssessmentRestClient.CreateListByExtendedResourceRequest(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => new ServerVulnerabilityAssessmentResource(Client, ServerVulnerabilityAssessmentData.DeserializeServerVulnerabilityAssessmentData(e)), _serverVulnerabilityAssessmentClientDiagnostics, Pipeline, "ServerVulnerabilityAssessmentCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of server vulnerability assessment onboarding statuses on a given resource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessment_ListByExtendedResource</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="ServerVulnerabilityAssessmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<ServerVulnerabilityAssessmentResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _serverVulnerabilityAssessmentRestClient.CreateListByExtendedResourceRequest(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => new ServerVulnerabilityAssessmentResource(Client, ServerVulnerabilityAssessmentData.DeserializeServerVulnerabilityAssessmentData(e)), _serverVulnerabilityAssessmentClientDiagnostics, Pipeline, "ServerVulnerabilityAssessmentCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessment_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessment_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentCollection.Exists");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessment_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<ServerVulnerabilityAssessmentResource>> GetIfExistsAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _serverVulnerabilityAssessmentRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<ServerVulnerabilityAssessmentResource>(response.GetRawResponse());
                return Response.FromValue(new ServerVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceNamespace}/{resourceType}/{resourceName}/providers/Microsoft.Security/serverVulnerabilityAssessments/{serverVulnerabilityAssessment}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ServerVulnerabilityAssessment_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ServerVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<ServerVulnerabilityAssessmentResource> GetIfExists(CancellationToken cancellationToken = default)
        {
            using var scope = _serverVulnerabilityAssessmentClientDiagnostics.CreateScope("ServerVulnerabilityAssessmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _serverVulnerabilityAssessmentRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, _resourceNamespace, _resourceType, _resourceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<ServerVulnerabilityAssessmentResource>(response.GetRawResponse());
                return Response.FromValue(new ServerVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<ServerVulnerabilityAssessmentResource> IEnumerable<ServerVulnerabilityAssessmentResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<ServerVulnerabilityAssessmentResource> IAsyncEnumerable<ServerVulnerabilityAssessmentResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
