// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityOperatorResource"/> and their operations.
    /// Each <see cref="SecurityOperatorResource"/> in the collection will belong to the same instance of <see cref="SecurityCenterPricingResource"/>.
    /// To get a <see cref="SecurityOperatorCollection"/> instance call the GetSecurityOperators method from an instance of <see cref="SecurityCenterPricingResource"/>.
    /// </summary>
    public partial class SecurityOperatorCollection : ArmCollection, IEnumerable<SecurityOperatorResource>, IAsyncEnumerable<SecurityOperatorResource>
    {
        private readonly ClientDiagnostics _securityOperatorClientDiagnostics;
        private readonly SecurityOperatorsRestOperations _securityOperatorRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityOperatorCollection"/> class for mocking. </summary>
        protected SecurityOperatorCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityOperatorCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityOperatorCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityOperatorClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", SecurityOperatorResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityOperatorResource.ResourceType, out string securityOperatorApiVersion);
            _securityOperatorRestClient = new SecurityOperatorsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityOperatorApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SecurityCenterPricingResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SecurityCenterPricingResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates Microsoft Defender for Cloud security operator on the given scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecurityOperators_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityOperatorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securityOperatorName"/> is null. </exception>
        public virtual async Task<ArmOperation<SecurityOperatorResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var scope = _securityOperatorClientDiagnostics.CreateScope("SecurityOperatorCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _securityOperatorRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.Name, securityOperatorName, cancellationToken).ConfigureAwait(false);
                var uri = _securityOperatorRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.Name, securityOperatorName);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<SecurityOperatorResource>(Response.FromValue(new SecurityOperatorResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates Microsoft Defender for Cloud security operator on the given scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecurityOperators_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityOperatorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securityOperatorName"/> is null. </exception>
        public virtual ArmOperation<SecurityOperatorResource> CreateOrUpdate(WaitUntil waitUntil, string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var scope = _securityOperatorClientDiagnostics.CreateScope("SecurityOperatorCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _securityOperatorRestClient.CreateOrUpdate(Id.SubscriptionId, Id.Name, securityOperatorName, cancellationToken);
                var uri = _securityOperatorRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.Name, securityOperatorName);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<SecurityOperatorResource>(Response.FromValue(new SecurityOperatorResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a specific security operator for the requested scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecurityOperators_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityOperatorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securityOperatorName"/> is null. </exception>
        public virtual async Task<Response<SecurityOperatorResource>> GetAsync(string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var scope = _securityOperatorClientDiagnostics.CreateScope("SecurityOperatorCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityOperatorRestClient.GetAsync(Id.SubscriptionId, Id.Name, securityOperatorName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityOperatorResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a specific security operator for the requested scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecurityOperators_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityOperatorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securityOperatorName"/> is null. </exception>
        public virtual Response<SecurityOperatorResource> Get(string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var scope = _securityOperatorClientDiagnostics.CreateScope("SecurityOperatorCollection.Get");
            scope.Start();
            try
            {
                var response = _securityOperatorRestClient.Get(Id.SubscriptionId, Id.Name, securityOperatorName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityOperatorResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists Microsoft Defender for Cloud securityOperators in the subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecurityOperators_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityOperatorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityOperatorResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityOperatorResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityOperatorRestClient.CreateListRequest(Id.SubscriptionId, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => new SecurityOperatorResource(Client, SecurityOperatorData.DeserializeSecurityOperatorData(e)), _securityOperatorClientDiagnostics, Pipeline, "SecurityOperatorCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Lists Microsoft Defender for Cloud securityOperators in the subscription.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecurityOperators_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityOperatorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityOperatorResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityOperatorResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityOperatorRestClient.CreateListRequest(Id.SubscriptionId, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => new SecurityOperatorResource(Client, SecurityOperatorData.DeserializeSecurityOperatorData(e)), _securityOperatorClientDiagnostics, Pipeline, "SecurityOperatorCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecurityOperators_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityOperatorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securityOperatorName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var scope = _securityOperatorClientDiagnostics.CreateScope("SecurityOperatorCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityOperatorRestClient.GetAsync(Id.SubscriptionId, Id.Name, securityOperatorName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecurityOperators_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityOperatorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securityOperatorName"/> is null. </exception>
        public virtual Response<bool> Exists(string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var scope = _securityOperatorClientDiagnostics.CreateScope("SecurityOperatorCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityOperatorRestClient.Get(Id.SubscriptionId, Id.Name, securityOperatorName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecurityOperators_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityOperatorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securityOperatorName"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityOperatorResource>> GetIfExistsAsync(string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var scope = _securityOperatorClientDiagnostics.CreateScope("SecurityOperatorCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityOperatorRestClient.GetAsync(Id.SubscriptionId, Id.Name, securityOperatorName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityOperatorResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityOperatorResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/pricings/{pricingName}/securityOperators/{securityOperatorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SecurityOperators_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityOperatorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="securityOperatorName"/> is null. </exception>
        public virtual NullableResponse<SecurityOperatorResource> GetIfExists(string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var scope = _securityOperatorClientDiagnostics.CreateScope("SecurityOperatorCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityOperatorRestClient.Get(Id.SubscriptionId, Id.Name, securityOperatorName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityOperatorResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityOperatorResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityOperatorResource> IEnumerable<SecurityOperatorResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityOperatorResource> IAsyncEnumerable<SecurityOperatorResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
