// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A Class representing a SecurityHealthReport along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SecurityHealthReportResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSecurityHealthReportResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetSecurityHealthReport method.
    /// </summary>
    public partial class SecurityHealthReportResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SecurityHealthReportResource"/> instance. </summary>
        /// <param name="resourceId"> The resourceId. </param>
        /// <param name="healthReportName"> The healthReportName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string resourceId, string healthReportName)
        {
            var resourceId0 = $"{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}";
            return new ResourceIdentifier(resourceId0);
        }

        private readonly ClientDiagnostics _securityHealthReportHealthReportsClientDiagnostics;
        private readonly HealthReportsRestOperations _securityHealthReportHealthReportsRestClient;
        private readonly SecurityHealthReportData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Security/healthReports";

        /// <summary> Initializes a new instance of the <see cref="SecurityHealthReportResource"/> class for mocking. </summary>
        protected SecurityHealthReportResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityHealthReportResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SecurityHealthReportResource(ArmClient client, SecurityHealthReportData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityHealthReportResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SecurityHealthReportResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityHealthReportHealthReportsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string securityHealthReportHealthReportsApiVersion);
            _securityHealthReportHealthReportsRestClient = new HealthReportsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityHealthReportHealthReportsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SecurityHealthReportData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get health report of resource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HealthReports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityHealthReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SecurityHealthReportResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _securityHealthReportHealthReportsClientDiagnostics.CreateScope("SecurityHealthReportResource.Get");
            scope.Start();
            try
            {
                var response = await _securityHealthReportHealthReportsRestClient.GetAsync(Id.Parent, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityHealthReportResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get health report of resource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HealthReports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityHealthReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SecurityHealthReportResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _securityHealthReportHealthReportsClientDiagnostics.CreateScope("SecurityHealthReportResource.Get");
            scope.Start();
            try
            {
                var response = _securityHealthReportHealthReportsRestClient.Get(Id.Parent, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityHealthReportResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
