// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityHealthReportResource"/> and their operations.
    /// Each <see cref="SecurityHealthReportResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="SecurityHealthReportCollection"/> instance call the GetSecurityHealthReports method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class SecurityHealthReportCollection : ArmCollection, IEnumerable<SecurityHealthReportResource>, IAsyncEnumerable<SecurityHealthReportResource>
    {
        private readonly ClientDiagnostics _securityHealthReportHealthReportsClientDiagnostics;
        private readonly HealthReportsRestOperations _securityHealthReportHealthReportsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityHealthReportCollection"/> class for mocking. </summary>
        protected SecurityHealthReportCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityHealthReportCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityHealthReportCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityHealthReportHealthReportsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", SecurityHealthReportResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityHealthReportResource.ResourceType, out string securityHealthReportHealthReportsApiVersion);
            _securityHealthReportHealthReportsRestClient = new HealthReportsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityHealthReportHealthReportsApiVersion);
        }

        /// <summary>
        /// Get health report of resource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HealthReports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityHealthReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="healthReportName"> The health report Key - Unique key for the health report type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="healthReportName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="healthReportName"/> is null. </exception>
        public virtual async Task<Response<SecurityHealthReportResource>> GetAsync(string healthReportName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(healthReportName, nameof(healthReportName));

            using var scope = _securityHealthReportHealthReportsClientDiagnostics.CreateScope("SecurityHealthReportCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityHealthReportHealthReportsRestClient.GetAsync(Id, healthReportName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityHealthReportResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get health report of resource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HealthReports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityHealthReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="healthReportName"> The health report Key - Unique key for the health report type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="healthReportName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="healthReportName"/> is null. </exception>
        public virtual Response<SecurityHealthReportResource> Get(string healthReportName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(healthReportName, nameof(healthReportName));

            using var scope = _securityHealthReportHealthReportsClientDiagnostics.CreateScope("SecurityHealthReportCollection.Get");
            scope.Start();
            try
            {
                var response = _securityHealthReportHealthReportsRestClient.Get(Id, healthReportName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityHealthReportResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a list of all health reports inside a scope. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/healthReports</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HealthReports_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityHealthReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityHealthReportResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityHealthReportResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityHealthReportHealthReportsRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityHealthReportHealthReportsRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityHealthReportResource(Client, SecurityHealthReportData.DeserializeSecurityHealthReportData(e)), _securityHealthReportHealthReportsClientDiagnostics, Pipeline, "SecurityHealthReportCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Get a list of all health reports inside a scope. Valid scopes are: subscription (format: 'subscriptions/{subscriptionId}'), or security connector (format: 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/healthReports</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HealthReports_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityHealthReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityHealthReportResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityHealthReportResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityHealthReportHealthReportsRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityHealthReportHealthReportsRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityHealthReportResource(Client, SecurityHealthReportData.DeserializeSecurityHealthReportData(e)), _securityHealthReportHealthReportsClientDiagnostics, Pipeline, "SecurityHealthReportCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HealthReports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityHealthReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="healthReportName"> The health report Key - Unique key for the health report type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="healthReportName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="healthReportName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string healthReportName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(healthReportName, nameof(healthReportName));

            using var scope = _securityHealthReportHealthReportsClientDiagnostics.CreateScope("SecurityHealthReportCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityHealthReportHealthReportsRestClient.GetAsync(Id, healthReportName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HealthReports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityHealthReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="healthReportName"> The health report Key - Unique key for the health report type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="healthReportName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="healthReportName"/> is null. </exception>
        public virtual Response<bool> Exists(string healthReportName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(healthReportName, nameof(healthReportName));

            using var scope = _securityHealthReportHealthReportsClientDiagnostics.CreateScope("SecurityHealthReportCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityHealthReportHealthReportsRestClient.Get(Id, healthReportName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HealthReports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityHealthReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="healthReportName"> The health report Key - Unique key for the health report type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="healthReportName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="healthReportName"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityHealthReportResource>> GetIfExistsAsync(string healthReportName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(healthReportName, nameof(healthReportName));

            using var scope = _securityHealthReportHealthReportsClientDiagnostics.CreateScope("SecurityHealthReportCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityHealthReportHealthReportsRestClient.GetAsync(Id, healthReportName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityHealthReportResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityHealthReportResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/healthReports/{healthReportName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HealthReports_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityHealthReportResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="healthReportName"> The health report Key - Unique key for the health report type. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="healthReportName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="healthReportName"/> is null. </exception>
        public virtual NullableResponse<SecurityHealthReportResource> GetIfExists(string healthReportName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(healthReportName, nameof(healthReportName));

            using var scope = _securityHealthReportHealthReportsClientDiagnostics.CreateScope("SecurityHealthReportCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityHealthReportHealthReportsRestClient.Get(Id, healthReportName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityHealthReportResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityHealthReportResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityHealthReportResource> IEnumerable<SecurityHealthReportResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityHealthReportResource> IAsyncEnumerable<SecurityHealthReportResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
