// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A Class representing a SecurityCompliance along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SecurityComplianceResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSecurityComplianceResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetSecurityCompliance method.
    /// </summary>
    public partial class SecurityComplianceResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SecurityComplianceResource"/> instance. </summary>
        /// <param name="scope"> The scope. </param>
        /// <param name="complianceName"> The complianceName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string scope, string complianceName)
        {
            var resourceId = $"{scope}/providers/Microsoft.Security/compliances/{complianceName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _securityComplianceCompliancesClientDiagnostics;
        private readonly CompliancesRestOperations _securityComplianceCompliancesRestClient;
        private readonly SecurityComplianceData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Security/compliances";

        /// <summary> Initializes a new instance of the <see cref="SecurityComplianceResource"/> class for mocking. </summary>
        protected SecurityComplianceResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityComplianceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SecurityComplianceResource(ArmClient client, SecurityComplianceData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityComplianceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SecurityComplianceResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityComplianceCompliancesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string securityComplianceCompliancesApiVersion);
            _securityComplianceCompliancesRestClient = new CompliancesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityComplianceCompliancesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SecurityComplianceData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Details of a specific Compliance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/compliances/{complianceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Compliances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityComplianceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SecurityComplianceResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _securityComplianceCompliancesClientDiagnostics.CreateScope("SecurityComplianceResource.Get");
            scope.Start();
            try
            {
                var response = await _securityComplianceCompliancesRestClient.GetAsync(Id.Parent, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityComplianceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Details of a specific Compliance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/compliances/{complianceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Compliances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityComplianceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SecurityComplianceResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _securityComplianceCompliancesClientDiagnostics.CreateScope("SecurityComplianceResource.Get");
            scope.Start();
            try
            {
                var response = _securityComplianceCompliancesRestClient.Get(Id.Parent, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityComplianceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
