// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityComplianceResource"/> and their operations.
    /// Each <see cref="SecurityComplianceResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="SecurityComplianceCollection"/> instance call the GetSecurityCompliances method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class SecurityComplianceCollection : ArmCollection, IEnumerable<SecurityComplianceResource>, IAsyncEnumerable<SecurityComplianceResource>
    {
        private readonly ClientDiagnostics _securityComplianceCompliancesClientDiagnostics;
        private readonly CompliancesRestOperations _securityComplianceCompliancesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityComplianceCollection"/> class for mocking. </summary>
        protected SecurityComplianceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityComplianceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityComplianceCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityComplianceCompliancesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", SecurityComplianceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityComplianceResource.ResourceType, out string securityComplianceCompliancesApiVersion);
            _securityComplianceCompliancesRestClient = new CompliancesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityComplianceCompliancesApiVersion);
        }

        /// <summary>
        /// Details of a specific Compliance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/compliances/{complianceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Compliances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityComplianceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceName"> name of the Compliance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceName"/> is null. </exception>
        public virtual async Task<Response<SecurityComplianceResource>> GetAsync(string complianceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceName, nameof(complianceName));

            using var scope = _securityComplianceCompliancesClientDiagnostics.CreateScope("SecurityComplianceCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityComplianceCompliancesRestClient.GetAsync(Id, complianceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityComplianceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Details of a specific Compliance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/compliances/{complianceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Compliances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityComplianceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceName"> name of the Compliance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceName"/> is null. </exception>
        public virtual Response<SecurityComplianceResource> Get(string complianceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceName, nameof(complianceName));

            using var scope = _securityComplianceCompliancesClientDiagnostics.CreateScope("SecurityComplianceCollection.Get");
            scope.Start();
            try
            {
                var response = _securityComplianceCompliancesRestClient.Get(Id, complianceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityComplianceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The Compliance scores of the specific management group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/compliances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Compliances_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityComplianceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityComplianceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityComplianceResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityComplianceCompliancesRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityComplianceCompliancesRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityComplianceResource(Client, SecurityComplianceData.DeserializeSecurityComplianceData(e)), _securityComplianceCompliancesClientDiagnostics, Pipeline, "SecurityComplianceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// The Compliance scores of the specific management group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/compliances</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Compliances_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityComplianceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityComplianceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityComplianceResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityComplianceCompliancesRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityComplianceCompliancesRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityComplianceResource(Client, SecurityComplianceData.DeserializeSecurityComplianceData(e)), _securityComplianceCompliancesClientDiagnostics, Pipeline, "SecurityComplianceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/compliances/{complianceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Compliances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityComplianceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceName"> name of the Compliance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string complianceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceName, nameof(complianceName));

            using var scope = _securityComplianceCompliancesClientDiagnostics.CreateScope("SecurityComplianceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityComplianceCompliancesRestClient.GetAsync(Id, complianceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/compliances/{complianceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Compliances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityComplianceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceName"> name of the Compliance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceName"/> is null. </exception>
        public virtual Response<bool> Exists(string complianceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceName, nameof(complianceName));

            using var scope = _securityComplianceCompliancesClientDiagnostics.CreateScope("SecurityComplianceCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityComplianceCompliancesRestClient.Get(Id, complianceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/compliances/{complianceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Compliances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityComplianceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceName"> name of the Compliance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceName"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityComplianceResource>> GetIfExistsAsync(string complianceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceName, nameof(complianceName));

            using var scope = _securityComplianceCompliancesClientDiagnostics.CreateScope("SecurityComplianceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityComplianceCompliancesRestClient.GetAsync(Id, complianceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityComplianceResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityComplianceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{scope}/providers/Microsoft.Security/compliances/{complianceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Compliances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2017-08-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityComplianceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="complianceName"> name of the Compliance. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="complianceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="complianceName"/> is null. </exception>
        public virtual NullableResponse<SecurityComplianceResource> GetIfExists(string complianceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(complianceName, nameof(complianceName));

            using var scope = _securityComplianceCompliancesClientDiagnostics.CreateScope("SecurityComplianceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityComplianceCompliancesRestClient.Get(Id, complianceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityComplianceResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityComplianceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityComplianceResource> IEnumerable<SecurityComplianceResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityComplianceResource> IAsyncEnumerable<SecurityComplianceResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
