// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityCloudConnectorResource"/> and their operations.
    /// Each <see cref="SecurityCloudConnectorResource"/> in the collection will belong to the same instance of <see cref="SubscriptionResource"/>.
    /// To get a <see cref="SecurityCloudConnectorCollection"/> instance call the GetSecurityCloudConnectors method from an instance of <see cref="SubscriptionResource"/>.
    /// </summary>
    public partial class SecurityCloudConnectorCollection : ArmCollection, IEnumerable<SecurityCloudConnectorResource>, IAsyncEnumerable<SecurityCloudConnectorResource>
    {
        private readonly ClientDiagnostics _securityCloudConnectorConnectorsClientDiagnostics;
        private readonly ConnectorsRestOperations _securityCloudConnectorConnectorsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityCloudConnectorCollection"/> class for mocking. </summary>
        protected SecurityCloudConnectorCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityCloudConnectorCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityCloudConnectorCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityCloudConnectorConnectorsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", SecurityCloudConnectorResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityCloudConnectorResource.ResourceType, out string securityCloudConnectorConnectorsApiVersion);
            _securityCloudConnectorConnectorsRestClient = new ConnectorsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityCloudConnectorConnectorsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SubscriptionResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SubscriptionResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create a cloud account connector or update an existing one. Connect to your cloud account. For AWS, use either account credentials or role-based authentication. For GCP, use account organization credentials.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors/{connectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityCloudConnectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="connectorName"> Name of the cloud account connector. </param>
        /// <param name="data"> Settings for the cloud account connector. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectorName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SecurityCloudConnectorResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string connectorName, SecurityCloudConnectorData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectorName, nameof(connectorName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityCloudConnectorConnectorsClientDiagnostics.CreateScope("SecurityCloudConnectorCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _securityCloudConnectorConnectorsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, connectorName, data, cancellationToken).ConfigureAwait(false);
                var uri = _securityCloudConnectorConnectorsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, connectorName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<SecurityCloudConnectorResource>(Response.FromValue(new SecurityCloudConnectorResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a cloud account connector or update an existing one. Connect to your cloud account. For AWS, use either account credentials or role-based authentication. For GCP, use account organization credentials.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors/{connectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityCloudConnectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="connectorName"> Name of the cloud account connector. </param>
        /// <param name="data"> Settings for the cloud account connector. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectorName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SecurityCloudConnectorResource> CreateOrUpdate(WaitUntil waitUntil, string connectorName, SecurityCloudConnectorData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectorName, nameof(connectorName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityCloudConnectorConnectorsClientDiagnostics.CreateScope("SecurityCloudConnectorCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _securityCloudConnectorConnectorsRestClient.CreateOrUpdate(Id.SubscriptionId, connectorName, data, cancellationToken);
                var uri = _securityCloudConnectorConnectorsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, connectorName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<SecurityCloudConnectorResource>(Response.FromValue(new SecurityCloudConnectorResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Details of a specific cloud account connector
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors/{connectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityCloudConnectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectorName"> Name of the cloud account connector. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectorName"/> is null. </exception>
        public virtual async Task<Response<SecurityCloudConnectorResource>> GetAsync(string connectorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectorName, nameof(connectorName));

            using var scope = _securityCloudConnectorConnectorsClientDiagnostics.CreateScope("SecurityCloudConnectorCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityCloudConnectorConnectorsRestClient.GetAsync(Id.SubscriptionId, connectorName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityCloudConnectorResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Details of a specific cloud account connector
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors/{connectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityCloudConnectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectorName"> Name of the cloud account connector. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectorName"/> is null. </exception>
        public virtual Response<SecurityCloudConnectorResource> Get(string connectorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectorName, nameof(connectorName));

            using var scope = _securityCloudConnectorConnectorsClientDiagnostics.CreateScope("SecurityCloudConnectorCollection.Get");
            scope.Start();
            try
            {
                var response = _securityCloudConnectorConnectorsRestClient.Get(Id.SubscriptionId, connectorName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityCloudConnectorResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Cloud accounts connectors of a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityCloudConnectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityCloudConnectorResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityCloudConnectorResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityCloudConnectorConnectorsRestClient.CreateListRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityCloudConnectorConnectorsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityCloudConnectorResource(Client, SecurityCloudConnectorData.DeserializeSecurityCloudConnectorData(e)), _securityCloudConnectorConnectorsClientDiagnostics, Pipeline, "SecurityCloudConnectorCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Cloud accounts connectors of a subscription
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityCloudConnectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityCloudConnectorResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityCloudConnectorResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityCloudConnectorConnectorsRestClient.CreateListRequest(Id.SubscriptionId);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityCloudConnectorConnectorsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityCloudConnectorResource(Client, SecurityCloudConnectorData.DeserializeSecurityCloudConnectorData(e)), _securityCloudConnectorConnectorsClientDiagnostics, Pipeline, "SecurityCloudConnectorCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors/{connectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityCloudConnectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectorName"> Name of the cloud account connector. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectorName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string connectorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectorName, nameof(connectorName));

            using var scope = _securityCloudConnectorConnectorsClientDiagnostics.CreateScope("SecurityCloudConnectorCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityCloudConnectorConnectorsRestClient.GetAsync(Id.SubscriptionId, connectorName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors/{connectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityCloudConnectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectorName"> Name of the cloud account connector. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectorName"/> is null. </exception>
        public virtual Response<bool> Exists(string connectorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectorName, nameof(connectorName));

            using var scope = _securityCloudConnectorConnectorsClientDiagnostics.CreateScope("SecurityCloudConnectorCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityCloudConnectorConnectorsRestClient.Get(Id.SubscriptionId, connectorName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors/{connectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityCloudConnectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectorName"> Name of the cloud account connector. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectorName"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityCloudConnectorResource>> GetIfExistsAsync(string connectorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectorName, nameof(connectorName));

            using var scope = _securityCloudConnectorConnectorsClientDiagnostics.CreateScope("SecurityCloudConnectorCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityCloudConnectorConnectorsRestClient.GetAsync(Id.SubscriptionId, connectorName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityCloudConnectorResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityCloudConnectorResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/providers/Microsoft.Security/connectors/{connectorName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Connectors_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityCloudConnectorResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="connectorName"> Name of the cloud account connector. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="connectorName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="connectorName"/> is null. </exception>
        public virtual NullableResponse<SecurityCloudConnectorResource> GetIfExists(string connectorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(connectorName, nameof(connectorName));

            using var scope = _securityCloudConnectorConnectorsClientDiagnostics.CreateScope("SecurityCloudConnectorCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityCloudConnectorConnectorsRestClient.Get(Id.SubscriptionId, connectorName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityCloudConnectorResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityCloudConnectorResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityCloudConnectorResource> IEnumerable<SecurityCloudConnectorResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityCloudConnectorResource> IAsyncEnumerable<SecurityCloudConnectorResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
