// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing the SecurityCenterApiCollection data model.
    /// An API collection as represented by Microsoft Defender for APIs.
    /// </summary>
    public partial class SecurityCenterApiCollectionData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityCenterApiCollectionData"/>. </summary>
        public SecurityCenterApiCollectionData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SecurityCenterApiCollectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Gets the provisioning state of the API collection. </param>
        /// <param name="displayName"> The display name of the API collection. </param>
        /// <param name="discoveredVia"> The resource Id of the resource from where this API collection was discovered. </param>
        /// <param name="baseUri"> The base URI for this API collection. All endpoints of this API collection extend this base URI. </param>
        /// <param name="numberOfApiEndpoints"> The number of API endpoints discovered in this API collection. </param>
        /// <param name="numberOfInactiveApiEndpoints"> The number of API endpoints in this API collection that have not received any API traffic in the last 30 days. </param>
        /// <param name="numberOfUnauthenticatedApiEndpoints"> The number of API endpoints in this API collection that are unauthenticated. </param>
        /// <param name="numberOfExternalApiEndpoints"> The number of API endpoints in this API collection for which API traffic from the internet was observed. </param>
        /// <param name="numberOfApiEndpointsWithSensitiveDataExposed"> The number of API endpoints in this API collection which are exposing sensitive data in their requests and/or responses. </param>
        /// <param name="sensitivityLabel"> The highest priority sensitivity label from Microsoft Purview in this API collection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityCenterApiCollectionData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, SecurityFamilyProvisioningState? provisioningState, string displayName, ResourceIdentifier discoveredVia, Uri baseUri, long? numberOfApiEndpoints, long? numberOfInactiveApiEndpoints, long? numberOfUnauthenticatedApiEndpoints, long? numberOfExternalApiEndpoints, long? numberOfApiEndpointsWithSensitiveDataExposed, string sensitivityLabel, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ProvisioningState = provisioningState;
            DisplayName = displayName;
            DiscoveredVia = discoveredVia;
            BaseUri = baseUri;
            NumberOfApiEndpoints = numberOfApiEndpoints;
            NumberOfInactiveApiEndpoints = numberOfInactiveApiEndpoints;
            NumberOfUnauthenticatedApiEndpoints = numberOfUnauthenticatedApiEndpoints;
            NumberOfExternalApiEndpoints = numberOfExternalApiEndpoints;
            NumberOfApiEndpointsWithSensitiveDataExposed = numberOfApiEndpointsWithSensitiveDataExposed;
            SensitivityLabel = sensitivityLabel;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the provisioning state of the API collection. </summary>
        public SecurityFamilyProvisioningState? ProvisioningState { get; }
        /// <summary> The display name of the API collection. </summary>
        public string DisplayName { get; }
        /// <summary> The resource Id of the resource from where this API collection was discovered. </summary>
        public ResourceIdentifier DiscoveredVia { get; }
        /// <summary> The base URI for this API collection. All endpoints of this API collection extend this base URI. </summary>
        public Uri BaseUri { get; }
        /// <summary> The number of API endpoints discovered in this API collection. </summary>
        public long? NumberOfApiEndpoints { get; }
        /// <summary> The number of API endpoints in this API collection that have not received any API traffic in the last 30 days. </summary>
        public long? NumberOfInactiveApiEndpoints { get; }
        /// <summary> The number of API endpoints in this API collection that are unauthenticated. </summary>
        public long? NumberOfUnauthenticatedApiEndpoints { get; }
        /// <summary> The number of API endpoints in this API collection for which API traffic from the internet was observed. </summary>
        public long? NumberOfExternalApiEndpoints { get; }
        /// <summary> The number of API endpoints in this API collection which are exposing sensitive data in their requests and/or responses. </summary>
        public long? NumberOfApiEndpointsWithSensitiveDataExposed { get; }
        /// <summary> The highest priority sensitivity label from Microsoft Purview in this API collection. </summary>
        public string SensitivityLabel { get; }
    }
}
