// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityAssessmentResource"/> and their operations.
    /// Each <see cref="SecurityAssessmentResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get a <see cref="SecurityAssessmentCollection"/> instance call the GetSecurityAssessments method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class SecurityAssessmentCollection : ArmCollection
    {
        private readonly ClientDiagnostics _securityAssessmentAssessmentsClientDiagnostics;
        private readonly AssessmentsRestOperations _securityAssessmentAssessmentsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityAssessmentCollection"/> class for mocking. </summary>
        protected SecurityAssessmentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityAssessmentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityAssessmentCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityAssessmentAssessmentsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityCenter", SecurityAssessmentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityAssessmentResource.ResourceType, out string securityAssessmentAssessmentsApiVersion);
            _securityAssessmentAssessmentsRestClient = new AssessmentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityAssessmentAssessmentsApiVersion);
        }

        /// <summary>
        /// Create a security assessment on your resource. An assessment metadata that describes this assessment must be predefined with the same name before inserting the assessment result
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assessments_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="assessmentName"> The Assessment Key - Unique key for the assessment type. </param>
        /// <param name="content"> Calculated assessment on a pre-defined assessment metadata. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assessmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assessmentName"/> or <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<SecurityAssessmentResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string assessmentName, SecurityAssessmentCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assessmentName, nameof(assessmentName));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _securityAssessmentAssessmentsClientDiagnostics.CreateScope("SecurityAssessmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _securityAssessmentAssessmentsRestClient.CreateOrUpdateAsync(Id, assessmentName, content, cancellationToken).ConfigureAwait(false);
                var uri = _securityAssessmentAssessmentsRestClient.CreateCreateOrUpdateRequestUri(Id, assessmentName, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<SecurityAssessmentResource>(Response.FromValue(new SecurityAssessmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create a security assessment on your resource. An assessment metadata that describes this assessment must be predefined with the same name before inserting the assessment result
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assessments_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="assessmentName"> The Assessment Key - Unique key for the assessment type. </param>
        /// <param name="content"> Calculated assessment on a pre-defined assessment metadata. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assessmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assessmentName"/> or <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<SecurityAssessmentResource> CreateOrUpdate(WaitUntil waitUntil, string assessmentName, SecurityAssessmentCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assessmentName, nameof(assessmentName));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _securityAssessmentAssessmentsClientDiagnostics.CreateScope("SecurityAssessmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _securityAssessmentAssessmentsRestClient.CreateOrUpdate(Id, assessmentName, content, cancellationToken);
                var uri = _securityAssessmentAssessmentsRestClient.CreateCreateOrUpdateRequestUri(Id, assessmentName, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityCenterArmOperation<SecurityAssessmentResource>(Response.FromValue(new SecurityAssessmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a security assessment on your scanned resource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assessmentName"> The Assessment Key - Unique key for the assessment type. </param>
        /// <param name="expand"> OData expand. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assessmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assessmentName"/> is null. </exception>
        public virtual async Task<Response<SecurityAssessmentResource>> GetAsync(string assessmentName, SecurityAssessmentODataExpand? expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assessmentName, nameof(assessmentName));

            using var scope = _securityAssessmentAssessmentsClientDiagnostics.CreateScope("SecurityAssessmentCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityAssessmentAssessmentsRestClient.GetAsync(Id, assessmentName, expand, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a security assessment on your scanned resource
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assessmentName"> The Assessment Key - Unique key for the assessment type. </param>
        /// <param name="expand"> OData expand. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assessmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assessmentName"/> is null. </exception>
        public virtual Response<SecurityAssessmentResource> Get(string assessmentName, SecurityAssessmentODataExpand? expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assessmentName, nameof(assessmentName));

            using var scope = _securityAssessmentAssessmentsClientDiagnostics.CreateScope("SecurityAssessmentCollection.Get");
            scope.Start();
            try
            {
                var response = _securityAssessmentAssessmentsRestClient.Get(Id, assessmentName, expand, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assessmentName"> The Assessment Key - Unique key for the assessment type. </param>
        /// <param name="expand"> OData expand. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assessmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assessmentName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string assessmentName, SecurityAssessmentODataExpand? expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assessmentName, nameof(assessmentName));

            using var scope = _securityAssessmentAssessmentsClientDiagnostics.CreateScope("SecurityAssessmentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityAssessmentAssessmentsRestClient.GetAsync(Id, assessmentName, expand, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assessmentName"> The Assessment Key - Unique key for the assessment type. </param>
        /// <param name="expand"> OData expand. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assessmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assessmentName"/> is null. </exception>
        public virtual Response<bool> Exists(string assessmentName, SecurityAssessmentODataExpand? expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assessmentName, nameof(assessmentName));

            using var scope = _securityAssessmentAssessmentsClientDiagnostics.CreateScope("SecurityAssessmentCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityAssessmentAssessmentsRestClient.Get(Id, assessmentName, expand, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assessmentName"> The Assessment Key - Unique key for the assessment type. </param>
        /// <param name="expand"> OData expand. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assessmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assessmentName"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityAssessmentResource>> GetIfExistsAsync(string assessmentName, SecurityAssessmentODataExpand? expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assessmentName, nameof(assessmentName));

            using var scope = _securityAssessmentAssessmentsClientDiagnostics.CreateScope("SecurityAssessmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityAssessmentAssessmentsRestClient.GetAsync(Id, assessmentName, expand, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityAssessmentResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceId}/providers/Microsoft.Security/assessments/{assessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2021-06-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assessmentName"> The Assessment Key - Unique key for the assessment type. </param>
        /// <param name="expand"> OData expand. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assessmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assessmentName"/> is null. </exception>
        public virtual NullableResponse<SecurityAssessmentResource> GetIfExists(string assessmentName, SecurityAssessmentODataExpand? expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assessmentName, nameof(assessmentName));

            using var scope = _securityAssessmentAssessmentsClientDiagnostics.CreateScope("SecurityAssessmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityAssessmentAssessmentsRestClient.Get(Id, assessmentName, expand, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityAssessmentResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
