// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    public partial class SecurityAlertData : IUtf8JsonSerializable, IJsonModel<SecurityAlertData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SecurityAlertData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SecurityAlertData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityAlertData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityAlertData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(Version))
            {
                writer.WritePropertyName("version"u8);
                writer.WriteStringValue(Version);
            }
            if (options.Format != "W" && Optional.IsDefined(AlertType))
            {
                writer.WritePropertyName("alertType"u8);
                writer.WriteStringValue(AlertType);
            }
            if (options.Format != "W" && Optional.IsDefined(SystemAlertId))
            {
                writer.WritePropertyName("systemAlertId"u8);
                writer.WriteStringValue(SystemAlertId);
            }
            if (options.Format != "W" && Optional.IsDefined(ProductComponentName))
            {
                writer.WritePropertyName("productComponentName"u8);
                writer.WriteStringValue(ProductComponentName);
            }
            if (options.Format != "W" && Optional.IsDefined(AlertDisplayName))
            {
                writer.WritePropertyName("alertDisplayName"u8);
                writer.WriteStringValue(AlertDisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (options.Format != "W" && Optional.IsDefined(Severity))
            {
                writer.WritePropertyName("severity"u8);
                writer.WriteStringValue(Severity.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Intent))
            {
                writer.WritePropertyName("intent"u8);
                writer.WriteStringValue(Intent.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startTimeUtc"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(EndOn))
            {
                writer.WritePropertyName("endTimeUtc"u8);
                writer.WriteStringValue(EndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ResourceIdentifiers))
            {
                writer.WritePropertyName("resourceIdentifiers"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceIdentifiers)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(RemediationSteps))
            {
                writer.WritePropertyName("remediationSteps"u8);
                writer.WriteStartArray();
                foreach (var item in RemediationSteps)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(VendorName))
            {
                writer.WritePropertyName("vendorName"u8);
                writer.WriteStringValue(VendorName);
            }
            if (options.Format != "W" && Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ExtendedLinks))
            {
                writer.WritePropertyName("extendedLinks"u8);
                writer.WriteStartArray();
                foreach (var item in ExtendedLinks)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStartObject();
                    foreach (var item0 in item)
                    {
                        writer.WritePropertyName(item0.Key);
                        writer.WriteStringValue(item0.Value);
                    }
                    writer.WriteEndObject();
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(AlertUri))
            {
                writer.WritePropertyName("alertUri"u8);
                writer.WriteStringValue(AlertUri.AbsoluteUri);
            }
            if (options.Format != "W" && Optional.IsDefined(GeneratedOn))
            {
                writer.WritePropertyName("timeGeneratedUtc"u8);
                writer.WriteStringValue(GeneratedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ProductName))
            {
                writer.WritePropertyName("productName"u8);
                writer.WriteStringValue(ProductName);
            }
            if (options.Format != "W" && Optional.IsDefined(ProcessingEndOn))
            {
                writer.WritePropertyName("processingEndTimeUtc"u8);
                writer.WriteStringValue(ProcessingEndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Entities))
            {
                writer.WritePropertyName("entities"u8);
                writer.WriteStartArray();
                foreach (var item in Entities)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(IsIncident))
            {
                writer.WritePropertyName("isIncident"u8);
                writer.WriteBooleanValue(IsIncident.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CorrelationKey))
            {
                writer.WritePropertyName("correlationKey"u8);
                writer.WriteStringValue(CorrelationKey);
            }
            if (Optional.IsCollectionDefined(ExtendedProperties))
            {
                writer.WritePropertyName("extendedProperties"u8);
                writer.WriteStartObject();
                foreach (var item in ExtendedProperties)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (options.Format != "W" && Optional.IsDefined(CompromisedEntity))
            {
                writer.WritePropertyName("compromisedEntity"u8);
                writer.WriteStringValue(CompromisedEntity);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Techniques))
            {
                writer.WritePropertyName("techniques"u8);
                writer.WriteStartArray();
                foreach (var item in Techniques)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SubTechniques))
            {
                writer.WritePropertyName("subTechniques"u8);
                writer.WriteStartArray();
                foreach (var item in SubTechniques)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(SupportingEvidence))
            {
                writer.WritePropertyName("supportingEvidence"u8);
                writer.WriteObjectValue(SupportingEvidence, options);
            }
            writer.WriteEndObject();
        }

        SecurityAlertData IJsonModel<SecurityAlertData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityAlertData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityAlertData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSecurityAlertData(document.RootElement, options);
        }

        internal static SecurityAlertData DeserializeSecurityAlertData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string version = default;
            string alertType = default;
            string systemAlertId = default;
            string productComponentName = default;
            string alertDisplayName = default;
            string description = default;
            SecurityAlertSeverity? severity = default;
            KillChainIntent? intent = default;
            DateTimeOffset? startTimeUtc = default;
            DateTimeOffset? endTimeUtc = default;
            IReadOnlyList<SecurityAlertResourceIdentifier> resourceIdentifiers = default;
            IReadOnlyList<string> remediationSteps = default;
            string vendorName = default;
            SecurityAlertStatus? status = default;
            IReadOnlyList<IDictionary<string, string>> extendedLinks = default;
            Uri alertUri = default;
            DateTimeOffset? timeGeneratedUtc = default;
            string productName = default;
            DateTimeOffset? processingEndTimeUtc = default;
            IReadOnlyList<SecurityAlertEntity> entities = default;
            bool? isIncident = default;
            string correlationKey = default;
            IDictionary<string, string> extendedProperties = default;
            string compromisedEntity = default;
            IReadOnlyList<string> techniques = default;
            IReadOnlyList<string> subTechniques = default;
            SecurityAlertSupportingEvidence supportingEvidence = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("version"u8))
                        {
                            version = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("alertType"u8))
                        {
                            alertType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("systemAlertId"u8))
                        {
                            systemAlertId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("productComponentName"u8))
                        {
                            productComponentName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("alertDisplayName"u8))
                        {
                            alertDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("severity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            severity = new SecurityAlertSeverity(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("intent"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            intent = new KillChainIntent(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("startTimeUtc"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            startTimeUtc = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("endTimeUtc"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            endTimeUtc = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("resourceIdentifiers"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SecurityAlertResourceIdentifier> array = new List<SecurityAlertResourceIdentifier>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SecurityAlertResourceIdentifier.DeserializeSecurityAlertResourceIdentifier(item, options));
                            }
                            resourceIdentifiers = array;
                            continue;
                        }
                        if (property0.NameEquals("remediationSteps"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            remediationSteps = array;
                            continue;
                        }
                        if (property0.NameEquals("vendorName"u8))
                        {
                            vendorName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("status"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            status = new SecurityAlertStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("extendedLinks"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<IDictionary<string, string>> array = new List<IDictionary<string, string>>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                if (item.ValueKind == JsonValueKind.Null)
                                {
                                    array.Add(null);
                                }
                                else
                                {
                                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                                    foreach (var property1 in item.EnumerateObject())
                                    {
                                        dictionary.Add(property1.Name, property1.Value.GetString());
                                    }
                                    array.Add(dictionary);
                                }
                            }
                            extendedLinks = array;
                            continue;
                        }
                        if (property0.NameEquals("alertUri"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            alertUri = new Uri(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("timeGeneratedUtc"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            timeGeneratedUtc = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("productName"u8))
                        {
                            productName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("processingEndTimeUtc"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            processingEndTimeUtc = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("entities"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SecurityAlertEntity> array = new List<SecurityAlertEntity>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SecurityAlertEntity.DeserializeSecurityAlertEntity(item, options));
                            }
                            entities = array;
                            continue;
                        }
                        if (property0.NameEquals("isIncident"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isIncident = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("correlationKey"u8))
                        {
                            correlationKey = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("extendedProperties"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, string> dictionary = new Dictionary<string, string>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                dictionary.Add(property1.Name, property1.Value.GetString());
                            }
                            extendedProperties = dictionary;
                            continue;
                        }
                        if (property0.NameEquals("compromisedEntity"u8))
                        {
                            compromisedEntity = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("techniques"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            techniques = array;
                            continue;
                        }
                        if (property0.NameEquals("subTechniques"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            subTechniques = array;
                            continue;
                        }
                        if (property0.NameEquals("supportingEvidence"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            supportingEvidence = SecurityAlertSupportingEvidence.DeserializeSecurityAlertSupportingEvidence(property0.Value, options);
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SecurityAlertData(
                id,
                name,
                type,
                systemData,
                version,
                alertType,
                systemAlertId,
                productComponentName,
                alertDisplayName,
                description,
                severity,
                intent,
                startTimeUtc,
                endTimeUtc,
                resourceIdentifiers ?? new ChangeTrackingList<SecurityAlertResourceIdentifier>(),
                remediationSteps ?? new ChangeTrackingList<string>(),
                vendorName,
                status,
                extendedLinks ?? new ChangeTrackingList<IDictionary<string, string>>(),
                alertUri,
                timeGeneratedUtc,
                productName,
                processingEndTimeUtc,
                entities ?? new ChangeTrackingList<SecurityAlertEntity>(),
                isIncident,
                correlationKey,
                extendedProperties ?? new ChangeTrackingDictionary<string, string>(),
                compromisedEntity,
                techniques ?? new ChangeTrackingList<string>(),
                subTechniques ?? new ChangeTrackingList<string>(),
                supportingEvidence,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SecurityAlertData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityAlertData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SecurityAlertData)} does not support writing '{options.Format}' format.");
            }
        }

        SecurityAlertData IPersistableModel<SecurityAlertData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityAlertData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSecurityAlertData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SecurityAlertData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SecurityAlertData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
