// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    internal partial class SqlVulnerabilityAssessmentScanResultsRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of SqlVulnerabilityAssessmentScanResultsRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public SqlVulnerabilityAssessmentScanResultsRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2023-02-01-preview";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateGetRequestUri(string resourceId, string scanId, string scanResultId, Guid workspaceId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceId, false);
            uri.AppendPath("/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/", false);
            uri.AppendPath(scanId, true);
            uri.AppendPath("/scanResults/", false);
            uri.AppendPath(scanResultId, true);
            uri.AppendQuery("workspaceId", workspaceId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string resourceId, string scanId, string scanResultId, Guid workspaceId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceId, false);
            uri.AppendPath("/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/", false);
            uri.AppendPath(scanId, true);
            uri.AppendPath("/scanResults/", false);
            uri.AppendPath(scanResultId, true);
            uri.AppendQuery("workspaceId", workspaceId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets the scan results of a single rule in a scan record. </summary>
        /// <param name="resourceId"> The identifier of the resource. </param>
        /// <param name="scanId"> The scan Id. Type 'latest' to get the scan results for the latest scan. </param>
        /// <param name="scanResultId"> The rule Id of the results. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/>, <paramref name="scanId"/> or <paramref name="scanResultId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> or <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SqlVulnerabilityAssessmentScanResult>> GetAsync(string resourceId, string scanId, string scanResultId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var message = CreateGetRequest(resourceId, scanId, scanResultId, workspaceId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentScanResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SqlVulnerabilityAssessmentScanResult.DeserializeSqlVulnerabilityAssessmentScanResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the scan results of a single rule in a scan record. </summary>
        /// <param name="resourceId"> The identifier of the resource. </param>
        /// <param name="scanId"> The scan Id. Type 'latest' to get the scan results for the latest scan. </param>
        /// <param name="scanResultId"> The rule Id of the results. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/>, <paramref name="scanId"/> or <paramref name="scanResultId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> or <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SqlVulnerabilityAssessmentScanResult> Get(string resourceId, string scanId, string scanResultId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var message = CreateGetRequest(resourceId, scanId, scanResultId, workspaceId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentScanResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SqlVulnerabilityAssessmentScanResult.DeserializeSqlVulnerabilityAssessmentScanResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListRequestUri(string resourceId, string scanId, Guid workspaceId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceId, false);
            uri.AppendPath("/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/", false);
            uri.AppendPath(scanId, true);
            uri.AppendPath("/scanResults", false);
            uri.AppendQuery("workspaceId", workspaceId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListRequest(string resourceId, string scanId, Guid workspaceId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceId, false);
            uri.AppendPath("/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/scans/", false);
            uri.AppendPath(scanId, true);
            uri.AppendPath("/scanResults", false);
            uri.AppendQuery("workspaceId", workspaceId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a list of scan results for a single scan record. </summary>
        /// <param name="resourceId"> The identifier of the resource. </param>
        /// <param name="scanId"> The scan Id. Type 'latest' to get the scan results for the latest scan. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> or <paramref name="scanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<ScanResults>> ListAsync(string resourceId, string scanId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var message = CreateListRequest(resourceId, scanId, workspaceId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ScanResults value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ScanResults.DeserializeScanResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a list of scan results for a single scan record. </summary>
        /// <param name="resourceId"> The identifier of the resource. </param>
        /// <param name="scanId"> The scan Id. Type 'latest' to get the scan results for the latest scan. </param>
        /// <param name="workspaceId"> The workspace Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceId"/> or <paramref name="scanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<ScanResults> List(string resourceId, string scanId, Guid workspaceId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceId, nameof(resourceId));
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var message = CreateListRequest(resourceId, scanId, workspaceId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ScanResults value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ScanResults.DeserializeScanResults(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
