// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    internal partial class SecurityOperatorsRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of SecurityOperatorsRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public SecurityOperatorsRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2023-01-01-preview";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListRequestUri(string subscriptionId, string pricingName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/pricings/", false);
            uri.AppendPath(pricingName, true);
            uri.AppendPath("/securityOperators", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListRequest(string subscriptionId, string pricingName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/pricings/", false);
            uri.AppendPath(pricingName, true);
            uri.AppendPath("/securityOperators", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Lists Microsoft Defender for Cloud securityOperators in the subscription. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="pricingName"> name of the pricing configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="pricingName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="pricingName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SecurityOperatorList>> ListAsync(string subscriptionId, string pricingName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(pricingName, nameof(pricingName));

            using var message = CreateListRequest(subscriptionId, pricingName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SecurityOperatorList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SecurityOperatorList.DeserializeSecurityOperatorList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Lists Microsoft Defender for Cloud securityOperators in the subscription. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="pricingName"> name of the pricing configuration. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> or <paramref name="pricingName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> or <paramref name="pricingName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SecurityOperatorList> List(string subscriptionId, string pricingName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(pricingName, nameof(pricingName));

            using var message = CreateListRequest(subscriptionId, pricingName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SecurityOperatorList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SecurityOperatorList.DeserializeSecurityOperatorList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string pricingName, string securityOperatorName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/pricings/", false);
            uri.AppendPath(pricingName, true);
            uri.AppendPath("/securityOperators/", false);
            uri.AppendPath(securityOperatorName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string pricingName, string securityOperatorName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/pricings/", false);
            uri.AppendPath(pricingName, true);
            uri.AppendPath("/securityOperators/", false);
            uri.AppendPath(securityOperatorName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get a specific security operator for the requested scope. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="pricingName"> name of the pricing configuration. </param>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SecurityOperatorData>> GetAsync(string subscriptionId, string pricingName, string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(pricingName, nameof(pricingName));
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var message = CreateGetRequest(subscriptionId, pricingName, securityOperatorName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SecurityOperatorData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SecurityOperatorData.DeserializeSecurityOperatorData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((SecurityOperatorData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get a specific security operator for the requested scope. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="pricingName"> name of the pricing configuration. </param>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SecurityOperatorData> Get(string subscriptionId, string pricingName, string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(pricingName, nameof(pricingName));
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var message = CreateGetRequest(subscriptionId, pricingName, securityOperatorName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SecurityOperatorData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SecurityOperatorData.DeserializeSecurityOperatorData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((SecurityOperatorData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateOrUpdateRequestUri(string subscriptionId, string pricingName, string securityOperatorName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/pricings/", false);
            uri.AppendPath(pricingName, true);
            uri.AppendPath("/securityOperators/", false);
            uri.AppendPath(securityOperatorName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateOrUpdateRequest(string subscriptionId, string pricingName, string securityOperatorName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/pricings/", false);
            uri.AppendPath(pricingName, true);
            uri.AppendPath("/securityOperators/", false);
            uri.AppendPath(securityOperatorName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Creates Microsoft Defender for Cloud security operator on the given scope. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="pricingName"> name of the pricing configuration. </param>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SecurityOperatorData>> CreateOrUpdateAsync(string subscriptionId, string pricingName, string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(pricingName, nameof(pricingName));
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, pricingName, securityOperatorName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SecurityOperatorData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SecurityOperatorData.DeserializeSecurityOperatorData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates Microsoft Defender for Cloud security operator on the given scope. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="pricingName"> name of the pricing configuration. </param>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SecurityOperatorData> CreateOrUpdate(string subscriptionId, string pricingName, string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(pricingName, nameof(pricingName));
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, pricingName, securityOperatorName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SecurityOperatorData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SecurityOperatorData.DeserializeSecurityOperatorData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string subscriptionId, string pricingName, string securityOperatorName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/pricings/", false);
            uri.AppendPath(pricingName, true);
            uri.AppendPath("/securityOperators/", false);
            uri.AppendPath(securityOperatorName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string subscriptionId, string pricingName, string securityOperatorName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/pricings/", false);
            uri.AppendPath(pricingName, true);
            uri.AppendPath("/securityOperators/", false);
            uri.AppendPath(securityOperatorName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Delete Microsoft Defender for Cloud securityOperator in the subscription. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="pricingName"> name of the pricing configuration. </param>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAsync(string subscriptionId, string pricingName, string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(pricingName, nameof(pricingName));
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var message = CreateDeleteRequest(subscriptionId, pricingName, securityOperatorName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Delete Microsoft Defender for Cloud securityOperator in the subscription. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="pricingName"> name of the pricing configuration. </param>
        /// <param name="securityOperatorName"> name of the securityOperator. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="pricingName"/> or <paramref name="securityOperatorName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Delete(string subscriptionId, string pricingName, string securityOperatorName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(pricingName, nameof(pricingName));
            Argument.AssertNotNullOrEmpty(securityOperatorName, nameof(securityOperatorName));

            using var message = CreateDeleteRequest(subscriptionId, pricingName, securityOperatorName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
