// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    internal partial class RegulatoryComplianceAssessmentsRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of RegulatoryComplianceAssessmentsRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public RegulatoryComplianceAssessmentsRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2019-01-01-preview";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListRequestUri(string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string filter)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/regulatoryComplianceStandards/", false);
            uri.AppendPath(regulatoryComplianceStandardName, true);
            uri.AppendPath("/regulatoryComplianceControls/", false);
            uri.AppendPath(regulatoryComplianceControlName, true);
            uri.AppendPath("/regulatoryComplianceAssessments", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            return uri;
        }

        internal HttpMessage CreateListRequest(string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string filter)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/regulatoryComplianceStandards/", false);
            uri.AppendPath(regulatoryComplianceStandardName, true);
            uri.AppendPath("/regulatoryComplianceControls/", false);
            uri.AppendPath(regulatoryComplianceControlName, true);
            uri.AppendPath("/regulatoryComplianceAssessments", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Details and state of assessments mapped to selected regulatory compliance control. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="regulatoryComplianceStandardName"> Name of the regulatory compliance standard object. </param>
        /// <param name="regulatoryComplianceControlName"> Name of the regulatory compliance control object. </param>
        /// <param name="filter"> OData filter. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/> or <paramref name="regulatoryComplianceControlName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/> or <paramref name="regulatoryComplianceControlName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<RegulatoryComplianceAssessmentList>> ListAsync(string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string filter = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceStandardName, nameof(regulatoryComplianceStandardName));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceControlName, nameof(regulatoryComplianceControlName));

            using var message = CreateListRequest(subscriptionId, regulatoryComplianceStandardName, regulatoryComplianceControlName, filter);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RegulatoryComplianceAssessmentList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RegulatoryComplianceAssessmentList.DeserializeRegulatoryComplianceAssessmentList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Details and state of assessments mapped to selected regulatory compliance control. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="regulatoryComplianceStandardName"> Name of the regulatory compliance standard object. </param>
        /// <param name="regulatoryComplianceControlName"> Name of the regulatory compliance control object. </param>
        /// <param name="filter"> OData filter. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/> or <paramref name="regulatoryComplianceControlName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/> or <paramref name="regulatoryComplianceControlName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<RegulatoryComplianceAssessmentList> List(string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string filter = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceStandardName, nameof(regulatoryComplianceStandardName));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceControlName, nameof(regulatoryComplianceControlName));

            using var message = CreateListRequest(subscriptionId, regulatoryComplianceStandardName, regulatoryComplianceControlName, filter);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RegulatoryComplianceAssessmentList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RegulatoryComplianceAssessmentList.DeserializeRegulatoryComplianceAssessmentList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string regulatoryComplianceAssessmentName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/regulatoryComplianceStandards/", false);
            uri.AppendPath(regulatoryComplianceStandardName, true);
            uri.AppendPath("/regulatoryComplianceControls/", false);
            uri.AppendPath(regulatoryComplianceControlName, true);
            uri.AppendPath("/regulatoryComplianceAssessments/", false);
            uri.AppendPath(regulatoryComplianceAssessmentName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string regulatoryComplianceAssessmentName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/providers/Microsoft.Security/regulatoryComplianceStandards/", false);
            uri.AppendPath(regulatoryComplianceStandardName, true);
            uri.AppendPath("/regulatoryComplianceControls/", false);
            uri.AppendPath(regulatoryComplianceControlName, true);
            uri.AppendPath("/regulatoryComplianceAssessments/", false);
            uri.AppendPath(regulatoryComplianceAssessmentName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Supported regulatory compliance details and state for selected assessment. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="regulatoryComplianceStandardName"> Name of the regulatory compliance standard object. </param>
        /// <param name="regulatoryComplianceControlName"> Name of the regulatory compliance control object. </param>
        /// <param name="regulatoryComplianceAssessmentName"> Name of the regulatory compliance assessment object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/>, <paramref name="regulatoryComplianceControlName"/> or <paramref name="regulatoryComplianceAssessmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/>, <paramref name="regulatoryComplianceControlName"/> or <paramref name="regulatoryComplianceAssessmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<RegulatoryComplianceAssessmentData>> GetAsync(string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string regulatoryComplianceAssessmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceStandardName, nameof(regulatoryComplianceStandardName));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceControlName, nameof(regulatoryComplianceControlName));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceAssessmentName, nameof(regulatoryComplianceAssessmentName));

            using var message = CreateGetRequest(subscriptionId, regulatoryComplianceStandardName, regulatoryComplianceControlName, regulatoryComplianceAssessmentName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RegulatoryComplianceAssessmentData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RegulatoryComplianceAssessmentData.DeserializeRegulatoryComplianceAssessmentData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((RegulatoryComplianceAssessmentData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Supported regulatory compliance details and state for selected assessment. </summary>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="regulatoryComplianceStandardName"> Name of the regulatory compliance standard object. </param>
        /// <param name="regulatoryComplianceControlName"> Name of the regulatory compliance control object. </param>
        /// <param name="regulatoryComplianceAssessmentName"> Name of the regulatory compliance assessment object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/>, <paramref name="regulatoryComplianceControlName"/> or <paramref name="regulatoryComplianceAssessmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/>, <paramref name="regulatoryComplianceControlName"/> or <paramref name="regulatoryComplianceAssessmentName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<RegulatoryComplianceAssessmentData> Get(string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string regulatoryComplianceAssessmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceStandardName, nameof(regulatoryComplianceStandardName));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceControlName, nameof(regulatoryComplianceControlName));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceAssessmentName, nameof(regulatoryComplianceAssessmentName));

            using var message = CreateGetRequest(subscriptionId, regulatoryComplianceStandardName, regulatoryComplianceControlName, regulatoryComplianceAssessmentName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RegulatoryComplianceAssessmentData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RegulatoryComplianceAssessmentData.DeserializeRegulatoryComplianceAssessmentData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((RegulatoryComplianceAssessmentData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListNextPageRequestUri(string nextLink, string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string filter)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListNextPageRequest(string nextLink, string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string filter)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Details and state of assessments mapped to selected regulatory compliance control. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="regulatoryComplianceStandardName"> Name of the regulatory compliance standard object. </param>
        /// <param name="regulatoryComplianceControlName"> Name of the regulatory compliance control object. </param>
        /// <param name="filter"> OData filter. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/> or <paramref name="regulatoryComplianceControlName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/> or <paramref name="regulatoryComplianceControlName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<RegulatoryComplianceAssessmentList>> ListNextPageAsync(string nextLink, string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string filter = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceStandardName, nameof(regulatoryComplianceStandardName));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceControlName, nameof(regulatoryComplianceControlName));

            using var message = CreateListNextPageRequest(nextLink, subscriptionId, regulatoryComplianceStandardName, regulatoryComplianceControlName, filter);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RegulatoryComplianceAssessmentList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RegulatoryComplianceAssessmentList.DeserializeRegulatoryComplianceAssessmentList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Details and state of assessments mapped to selected regulatory compliance control. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> Azure subscription ID. </param>
        /// <param name="regulatoryComplianceStandardName"> Name of the regulatory compliance standard object. </param>
        /// <param name="regulatoryComplianceControlName"> Name of the regulatory compliance control object. </param>
        /// <param name="filter"> OData filter. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/> or <paramref name="regulatoryComplianceControlName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="regulatoryComplianceStandardName"/> or <paramref name="regulatoryComplianceControlName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<RegulatoryComplianceAssessmentList> ListNextPage(string nextLink, string subscriptionId, string regulatoryComplianceStandardName, string regulatoryComplianceControlName, string filter = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceStandardName, nameof(regulatoryComplianceStandardName));
            Argument.AssertNotNullOrEmpty(regulatoryComplianceControlName, nameof(regulatoryComplianceControlName));

            using var message = CreateListNextPageRequest(nextLink, subscriptionId, regulatoryComplianceStandardName, regulatoryComplianceControlName, filter);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RegulatoryComplianceAssessmentList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RegulatoryComplianceAssessmentList.DeserializeRegulatoryComplianceAssessmentList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
