// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityCenter.Models;

namespace Azure.ResourceManager.SecurityCenter
{
    public partial class RegulatoryComplianceAssessmentData : IUtf8JsonSerializable, IJsonModel<RegulatoryComplianceAssessmentData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RegulatoryComplianceAssessmentData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RegulatoryComplianceAssessmentData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RegulatoryComplianceAssessmentData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RegulatoryComplianceAssessmentData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (options.Format != "W" && Optional.IsDefined(AssessmentType))
            {
                writer.WritePropertyName("assessmentType"u8);
                writer.WriteStringValue(AssessmentType);
            }
            if (options.Format != "W" && Optional.IsDefined(AssessmentDetailsLink))
            {
                writer.WritePropertyName("assessmentDetailsLink"u8);
                writer.WriteStringValue(AssessmentDetailsLink);
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(PassedResources))
            {
                writer.WritePropertyName("passedResources"u8);
                writer.WriteNumberValue(PassedResources.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(FailedResources))
            {
                writer.WritePropertyName("failedResources"u8);
                writer.WriteNumberValue(FailedResources.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SkippedResources))
            {
                writer.WritePropertyName("skippedResources"u8);
                writer.WriteNumberValue(SkippedResources.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UnsupportedResources))
            {
                writer.WritePropertyName("unsupportedResources"u8);
                writer.WriteNumberValue(UnsupportedResources.Value);
            }
            writer.WriteEndObject();
        }

        RegulatoryComplianceAssessmentData IJsonModel<RegulatoryComplianceAssessmentData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RegulatoryComplianceAssessmentData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RegulatoryComplianceAssessmentData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRegulatoryComplianceAssessmentData(document.RootElement, options);
        }

        internal static RegulatoryComplianceAssessmentData DeserializeRegulatoryComplianceAssessmentData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string description = default;
            string assessmentType = default;
            string assessmentDetailsLink = default;
            RegulatoryComplianceState? state = default;
            int? passedResources = default;
            int? failedResources = default;
            int? skippedResources = default;
            int? unsupportedResources = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("assessmentType"u8))
                        {
                            assessmentType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("assessmentDetailsLink"u8))
                        {
                            assessmentDetailsLink = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = new RegulatoryComplianceState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("passedResources"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            passedResources = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("failedResources"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            failedResources = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("skippedResources"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            skippedResources = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("unsupportedResources"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            unsupportedResources = property0.Value.GetInt32();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RegulatoryComplianceAssessmentData(
                id,
                name,
                type,
                systemData,
                description,
                assessmentType,
                assessmentDetailsLink,
                state,
                passedResources,
                failedResources,
                skippedResources,
                unsupportedResources,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<RegulatoryComplianceAssessmentData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RegulatoryComplianceAssessmentData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(RegulatoryComplianceAssessmentData)} does not support writing '{options.Format}' format.");
            }
        }

        RegulatoryComplianceAssessmentData IPersistableModel<RegulatoryComplianceAssessmentData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RegulatoryComplianceAssessmentData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRegulatoryComplianceAssessmentData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RegulatoryComplianceAssessmentData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RegulatoryComplianceAssessmentData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
