// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The rule type. </summary>
    public readonly partial struct VulnerabilityAssessmentRuleType : IEquatable<VulnerabilityAssessmentRuleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VulnerabilityAssessmentRuleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VulnerabilityAssessmentRuleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BinaryValue = "Binary";
        private const string BaselineExpectedValue = "BaselineExpected";
        private const string PositiveListValue = "PositiveList";
        private const string NegativeListValue = "NegativeList";

        /// <summary> Binary. </summary>
        public static VulnerabilityAssessmentRuleType Binary { get; } = new VulnerabilityAssessmentRuleType(BinaryValue);
        /// <summary> BaselineExpected. </summary>
        public static VulnerabilityAssessmentRuleType BaselineExpected { get; } = new VulnerabilityAssessmentRuleType(BaselineExpectedValue);
        /// <summary> PositiveList. </summary>
        public static VulnerabilityAssessmentRuleType PositiveList { get; } = new VulnerabilityAssessmentRuleType(PositiveListValue);
        /// <summary> NegativeList. </summary>
        public static VulnerabilityAssessmentRuleType NegativeList { get; } = new VulnerabilityAssessmentRuleType(NegativeListValue);
        /// <summary> Determines if two <see cref="VulnerabilityAssessmentRuleType"/> values are the same. </summary>
        public static bool operator ==(VulnerabilityAssessmentRuleType left, VulnerabilityAssessmentRuleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VulnerabilityAssessmentRuleType"/> values are not the same. </summary>
        public static bool operator !=(VulnerabilityAssessmentRuleType left, VulnerabilityAssessmentRuleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VulnerabilityAssessmentRuleType"/>. </summary>
        public static implicit operator VulnerabilityAssessmentRuleType(string value) => new VulnerabilityAssessmentRuleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VulnerabilityAssessmentRuleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VulnerabilityAssessmentRuleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
