// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> vulnerability assessment rule metadata details. </summary>
    public partial class VulnerabilityAssessmentRule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VulnerabilityAssessmentRule"/>. </summary>
        public VulnerabilityAssessmentRule()
        {
            BenchmarkReferences = new ChangeTrackingList<BenchmarkReference>();
        }

        /// <summary> Initializes a new instance of <see cref="VulnerabilityAssessmentRule"/>. </summary>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="severity"> The rule severity. </param>
        /// <param name="category"> The rule category. </param>
        /// <param name="ruleType"> The rule type. </param>
        /// <param name="title"> The rule title. </param>
        /// <param name="description"> The rule description. </param>
        /// <param name="rationale"> The rule rationale. </param>
        /// <param name="queryCheck"> The rule query details. </param>
        /// <param name="benchmarkReferences"> The benchmark references. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VulnerabilityAssessmentRule(string ruleId, RuleSeverity? severity, string category, VulnerabilityAssessmentRuleType? ruleType, string title, string description, string rationale, VulnerabilityAssessmentRuleQueryCheck queryCheck, IList<BenchmarkReference> benchmarkReferences, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuleId = ruleId;
            Severity = severity;
            Category = category;
            RuleType = ruleType;
            Title = title;
            Description = description;
            Rationale = rationale;
            QueryCheck = queryCheck;
            BenchmarkReferences = benchmarkReferences;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The rule Id. </summary>
        public string RuleId { get; set; }
        /// <summary> The rule severity. </summary>
        public RuleSeverity? Severity { get; set; }
        /// <summary> The rule category. </summary>
        public string Category { get; set; }
        /// <summary> The rule type. </summary>
        public VulnerabilityAssessmentRuleType? RuleType { get; set; }
        /// <summary> The rule title. </summary>
        public string Title { get; set; }
        /// <summary> The rule description. </summary>
        public string Description { get; set; }
        /// <summary> The rule rationale. </summary>
        public string Rationale { get; set; }
        /// <summary> The rule query details. </summary>
        public VulnerabilityAssessmentRuleQueryCheck QueryCheck { get; set; }
        /// <summary> The benchmark references. </summary>
        public IList<BenchmarkReference> BenchmarkReferences { get; }
    }
}
