// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class VulnerabilityAssessmentRule : IUtf8JsonSerializable, IJsonModel<VulnerabilityAssessmentRule>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VulnerabilityAssessmentRule>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VulnerabilityAssessmentRule>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VulnerabilityAssessmentRule>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VulnerabilityAssessmentRule)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(RuleId))
            {
                writer.WritePropertyName("ruleId"u8);
                writer.WriteStringValue(RuleId);
            }
            if (Optional.IsDefined(Severity))
            {
                writer.WritePropertyName("severity"u8);
                writer.WriteStringValue(Severity.Value.ToString());
            }
            if (Optional.IsDefined(Category))
            {
                writer.WritePropertyName("category"u8);
                writer.WriteStringValue(Category);
            }
            if (Optional.IsDefined(RuleType))
            {
                writer.WritePropertyName("ruleType"u8);
                writer.WriteStringValue(RuleType.Value.ToString());
            }
            if (Optional.IsDefined(Title))
            {
                writer.WritePropertyName("title"u8);
                writer.WriteStringValue(Title);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(Rationale))
            {
                writer.WritePropertyName("rationale"u8);
                writer.WriteStringValue(Rationale);
            }
            if (Optional.IsDefined(QueryCheck))
            {
                writer.WritePropertyName("queryCheck"u8);
                writer.WriteObjectValue(QueryCheck, options);
            }
            if (Optional.IsCollectionDefined(BenchmarkReferences))
            {
                writer.WritePropertyName("benchmarkReferences"u8);
                writer.WriteStartArray();
                foreach (var item in BenchmarkReferences)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VulnerabilityAssessmentRule IJsonModel<VulnerabilityAssessmentRule>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VulnerabilityAssessmentRule>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VulnerabilityAssessmentRule)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVulnerabilityAssessmentRule(document.RootElement, options);
        }

        internal static VulnerabilityAssessmentRule DeserializeVulnerabilityAssessmentRule(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string ruleId = default;
            RuleSeverity? severity = default;
            string category = default;
            VulnerabilityAssessmentRuleType? ruleType = default;
            string title = default;
            string description = default;
            string rationale = default;
            VulnerabilityAssessmentRuleQueryCheck queryCheck = default;
            IList<BenchmarkReference> benchmarkReferences = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ruleId"u8))
                {
                    ruleId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("severity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    severity = new RuleSeverity(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("category"u8))
                {
                    category = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ruleType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ruleType = new VulnerabilityAssessmentRuleType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("title"u8))
                {
                    title = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("rationale"u8))
                {
                    rationale = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("queryCheck"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    queryCheck = VulnerabilityAssessmentRuleQueryCheck.DeserializeVulnerabilityAssessmentRuleQueryCheck(property.Value, options);
                    continue;
                }
                if (property.NameEquals("benchmarkReferences"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BenchmarkReference> array = new List<BenchmarkReference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BenchmarkReference.DeserializeBenchmarkReference(item, options));
                    }
                    benchmarkReferences = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VulnerabilityAssessmentRule(
                ruleId,
                severity,
                category,
                ruleType,
                title,
                description,
                rationale,
                queryCheck,
                benchmarkReferences ?? new ChangeTrackingList<BenchmarkReference>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VulnerabilityAssessmentRule>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VulnerabilityAssessmentRule>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VulnerabilityAssessmentRule)} does not support writing '{options.Format}' format.");
            }
        }

        VulnerabilityAssessmentRule IPersistableModel<VulnerabilityAssessmentRule>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VulnerabilityAssessmentRule>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVulnerabilityAssessmentRule(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VulnerabilityAssessmentRule)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VulnerabilityAssessmentRule>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
