// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'. </summary>
    public readonly partial struct VulnerabilityAssessmentAutoProvisioningType : IEquatable<VulnerabilityAssessmentAutoProvisioningType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VulnerabilityAssessmentAutoProvisioningType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VulnerabilityAssessmentAutoProvisioningType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string QualysValue = "Qualys";
        private const string TVMValue = "TVM";

        /// <summary> Qualys. </summary>
        public static VulnerabilityAssessmentAutoProvisioningType Qualys { get; } = new VulnerabilityAssessmentAutoProvisioningType(QualysValue);
        /// <summary> TVM. </summary>
        public static VulnerabilityAssessmentAutoProvisioningType TVM { get; } = new VulnerabilityAssessmentAutoProvisioningType(TVMValue);
        /// <summary> Determines if two <see cref="VulnerabilityAssessmentAutoProvisioningType"/> values are the same. </summary>
        public static bool operator ==(VulnerabilityAssessmentAutoProvisioningType left, VulnerabilityAssessmentAutoProvisioningType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VulnerabilityAssessmentAutoProvisioningType"/> values are not the same. </summary>
        public static bool operator !=(VulnerabilityAssessmentAutoProvisioningType left, VulnerabilityAssessmentAutoProvisioningType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VulnerabilityAssessmentAutoProvisioningType"/>. </summary>
        public static implicit operator VulnerabilityAssessmentAutoProvisioningType(string value) => new VulnerabilityAssessmentAutoProvisioningType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VulnerabilityAssessmentAutoProvisioningType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VulnerabilityAssessmentAutoProvisioningType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
