// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Represents a user that is recommended to be allowed for a certain rule. </summary>
    public partial class UserRecommendation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UserRecommendation"/>. </summary>
        public UserRecommendation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UserRecommendation"/>. </summary>
        /// <param name="username"> Represents a user that is recommended to be allowed for a certain rule. </param>
        /// <param name="recommendationAction"> The recommendation action of the machine or rule. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UserRecommendation(string username, RecommendationAction? recommendationAction, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Username = username;
            RecommendationAction = recommendationAction;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Represents a user that is recommended to be allowed for a certain rule. </summary>
        public string Username { get; set; }
        /// <summary> The recommendation action of the machine or rule. </summary>
        public RecommendationAction? RecommendationAction { get; set; }
    }
}
