// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Properties of the IoT Security solution's user defined resources. </summary>
    public partial class UserDefinedResourcesProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UserDefinedResourcesProperties"/>. </summary>
        /// <param name="query"> Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs"". </param>
        /// <param name="querySubscriptions"> List of Azure subscription ids on which the user defined resources query should be executed. </param>
        public UserDefinedResourcesProperties(string query, IEnumerable<string> querySubscriptions)
        {
            Query = query;
            QuerySubscriptions = querySubscriptions?.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="UserDefinedResourcesProperties"/>. </summary>
        /// <param name="query"> Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs"". </param>
        /// <param name="querySubscriptions"> List of Azure subscription ids on which the user defined resources query should be executed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UserDefinedResourcesProperties(string query, IList<string> querySubscriptions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Query = query;
            QuerySubscriptions = querySubscriptions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="UserDefinedResourcesProperties"/> for deserialization. </summary>
        internal UserDefinedResourcesProperties()
        {
        }

        /// <summary> Azure Resource Graph query which represents the security solution's user defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs"". </summary>
        public string Query { get; set; }
        /// <summary> List of Azure subscription ids on which the user defined resources query should be executed. </summary>
        public IList<string> QuerySubscriptions { get; set; }
    }
}
