// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Programmatic code for the status of the assessment. </summary>
    public readonly partial struct SubAssessmentStatusCode : IEquatable<SubAssessmentStatusCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SubAssessmentStatusCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SubAssessmentStatusCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HealthyValue = "Healthy";
        private const string UnhealthyValue = "Unhealthy";
        private const string NotApplicableValue = "NotApplicable";

        /// <summary> The resource is healthy. </summary>
        public static SubAssessmentStatusCode Healthy { get; } = new SubAssessmentStatusCode(HealthyValue);
        /// <summary> The resource has a security issue that needs to be addressed. </summary>
        public static SubAssessmentStatusCode Unhealthy { get; } = new SubAssessmentStatusCode(UnhealthyValue);
        /// <summary> Assessment for this resource did not happen. </summary>
        public static SubAssessmentStatusCode NotApplicable { get; } = new SubAssessmentStatusCode(NotApplicableValue);
        /// <summary> Determines if two <see cref="SubAssessmentStatusCode"/> values are the same. </summary>
        public static bool operator ==(SubAssessmentStatusCode left, SubAssessmentStatusCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SubAssessmentStatusCode"/> values are not the same. </summary>
        public static bool operator !=(SubAssessmentStatusCode left, SubAssessmentStatusCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SubAssessmentStatusCode"/>. </summary>
        public static implicit operator SubAssessmentStatusCode(string value) => new SubAssessmentStatusCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SubAssessmentStatusCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SubAssessmentStatusCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
