// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The scan status. </summary>
    public readonly partial struct SqlVulnerabilityAssessmentScanState : IEquatable<SqlVulnerabilityAssessmentScanState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentScanState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlVulnerabilityAssessmentScanState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FailedValue = "Failed";
        private const string FailedToRunValue = "FailedToRun";
        private const string InProgressValue = "InProgress";
        private const string PassedValue = "Passed";

        /// <summary> Failed. </summary>
        public static SqlVulnerabilityAssessmentScanState Failed { get; } = new SqlVulnerabilityAssessmentScanState(FailedValue);
        /// <summary> FailedToRun. </summary>
        public static SqlVulnerabilityAssessmentScanState FailedToRun { get; } = new SqlVulnerabilityAssessmentScanState(FailedToRunValue);
        /// <summary> InProgress. </summary>
        public static SqlVulnerabilityAssessmentScanState InProgress { get; } = new SqlVulnerabilityAssessmentScanState(InProgressValue);
        /// <summary> Passed. </summary>
        public static SqlVulnerabilityAssessmentScanState Passed { get; } = new SqlVulnerabilityAssessmentScanState(PassedValue);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentScanState"/> values are the same. </summary>
        public static bool operator ==(SqlVulnerabilityAssessmentScanState left, SqlVulnerabilityAssessmentScanState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentScanState"/> values are not the same. </summary>
        public static bool operator !=(SqlVulnerabilityAssessmentScanState left, SqlVulnerabilityAssessmentScanState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlVulnerabilityAssessmentScanState"/>. </summary>
        public static implicit operator SqlVulnerabilityAssessmentScanState(string value) => new SqlVulnerabilityAssessmentScanState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlVulnerabilityAssessmentScanState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlVulnerabilityAssessmentScanState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
