// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> The rule result status. </summary>
    public readonly partial struct SqlVulnerabilityAssessmentScanResultRuleStatus : IEquatable<SqlVulnerabilityAssessmentScanResultRuleStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentScanResultRuleStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlVulnerabilityAssessmentScanResultRuleStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NonFindingValue = "NonFinding";
        private const string FindingValue = "Finding";
        private const string InternalErrorValue = "InternalError";

        /// <summary> NonFinding. </summary>
        public static SqlVulnerabilityAssessmentScanResultRuleStatus NonFinding { get; } = new SqlVulnerabilityAssessmentScanResultRuleStatus(NonFindingValue);
        /// <summary> Finding. </summary>
        public static SqlVulnerabilityAssessmentScanResultRuleStatus Finding { get; } = new SqlVulnerabilityAssessmentScanResultRuleStatus(FindingValue);
        /// <summary> InternalError. </summary>
        public static SqlVulnerabilityAssessmentScanResultRuleStatus InternalError { get; } = new SqlVulnerabilityAssessmentScanResultRuleStatus(InternalErrorValue);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentScanResultRuleStatus"/> values are the same. </summary>
        public static bool operator ==(SqlVulnerabilityAssessmentScanResultRuleStatus left, SqlVulnerabilityAssessmentScanResultRuleStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlVulnerabilityAssessmentScanResultRuleStatus"/> values are not the same. </summary>
        public static bool operator !=(SqlVulnerabilityAssessmentScanResultRuleStatus left, SqlVulnerabilityAssessmentScanResultRuleStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlVulnerabilityAssessmentScanResultRuleStatus"/>. </summary>
        public static implicit operator SqlVulnerabilityAssessmentScanResultRuleStatus(string value) => new SqlVulnerabilityAssessmentScanResultRuleStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlVulnerabilityAssessmentScanResultRuleStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlVulnerabilityAssessmentScanResultRuleStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
