// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> A vulnerability assessment scan result properties for a single rule. </summary>
    public partial class SqlVulnerabilityAssessmentScanResultProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentScanResultProperties"/>. </summary>
        public SqlVulnerabilityAssessmentScanResultProperties()
        {
            QueryResults = new ChangeTrackingList<IList<string>>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentScanResultProperties"/>. </summary>
        /// <param name="ruleId"> The rule Id. </param>
        /// <param name="status"> The rule result status. </param>
        /// <param name="isTrimmed"> Indicated whether the results specified here are trimmed. </param>
        /// <param name="queryResults"> The results of the query that was run. </param>
        /// <param name="remediation"> Remediation details. </param>
        /// <param name="baselineAdjustedResult"> The rule result adjusted with baseline. </param>
        /// <param name="ruleMetadata"> vulnerability assessment rule metadata details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVulnerabilityAssessmentScanResultProperties(string ruleId, SqlVulnerabilityAssessmentScanResultRuleStatus? status, bool? isTrimmed, IList<IList<string>> queryResults, SqlVulnerabilityAssessmentRemediation remediation, BaselineAdjustedResult baselineAdjustedResult, VulnerabilityAssessmentRule ruleMetadata, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RuleId = ruleId;
            Status = status;
            IsTrimmed = isTrimmed;
            QueryResults = queryResults;
            Remediation = remediation;
            BaselineAdjustedResult = baselineAdjustedResult;
            RuleMetadata = ruleMetadata;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The rule Id. </summary>
        public string RuleId { get; set; }
        /// <summary> The rule result status. </summary>
        public SqlVulnerabilityAssessmentScanResultRuleStatus? Status { get; set; }
        /// <summary> Indicated whether the results specified here are trimmed. </summary>
        public bool? IsTrimmed { get; set; }
        /// <summary> The results of the query that was run. </summary>
        public IList<IList<string>> QueryResults { get; }
        /// <summary> Remediation details. </summary>
        public SqlVulnerabilityAssessmentRemediation Remediation { get; set; }
        /// <summary> The rule result adjusted with baseline. </summary>
        public BaselineAdjustedResult BaselineAdjustedResult { get; set; }
        /// <summary> vulnerability assessment rule metadata details. </summary>
        public VulnerabilityAssessmentRule RuleMetadata { get; set; }
    }
}
