// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class SqlVulnerabilityAssessmentScanResultProperties : IUtf8JsonSerializable, IJsonModel<SqlVulnerabilityAssessmentScanResultProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SqlVulnerabilityAssessmentScanResultProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SqlVulnerabilityAssessmentScanResultProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanResultProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanResultProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(RuleId))
            {
                writer.WritePropertyName("ruleId"u8);
                writer.WriteStringValue(RuleId);
            }
            if (Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status.Value.ToString());
            }
            if (Optional.IsDefined(IsTrimmed))
            {
                writer.WritePropertyName("isTrimmed"u8);
                writer.WriteBooleanValue(IsTrimmed.Value);
            }
            if (Optional.IsCollectionDefined(QueryResults))
            {
                writer.WritePropertyName("queryResults"u8);
                writer.WriteStartArray();
                foreach (var item in QueryResults)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
                    writer.WriteStartArray();
                    foreach (var item0 in item)
                    {
                        writer.WriteStringValue(item0);
                    }
                    writer.WriteEndArray();
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Remediation))
            {
                writer.WritePropertyName("remediation"u8);
                writer.WriteObjectValue(Remediation, options);
            }
            if (Optional.IsDefined(BaselineAdjustedResult))
            {
                writer.WritePropertyName("baselineAdjustedResult"u8);
                writer.WriteObjectValue(BaselineAdjustedResult, options);
            }
            if (Optional.IsDefined(RuleMetadata))
            {
                writer.WritePropertyName("ruleMetadata"u8);
                writer.WriteObjectValue(RuleMetadata, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SqlVulnerabilityAssessmentScanResultProperties IJsonModel<SqlVulnerabilityAssessmentScanResultProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanResultProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanResultProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSqlVulnerabilityAssessmentScanResultProperties(document.RootElement, options);
        }

        internal static SqlVulnerabilityAssessmentScanResultProperties DeserializeSqlVulnerabilityAssessmentScanResultProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string ruleId = default;
            SqlVulnerabilityAssessmentScanResultRuleStatus? status = default;
            bool? isTrimmed = default;
            IList<IList<string>> queryResults = default;
            SqlVulnerabilityAssessmentRemediation remediation = default;
            BaselineAdjustedResult baselineAdjustedResult = default;
            VulnerabilityAssessmentRule ruleMetadata = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("ruleId"u8))
                {
                    ruleId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    status = new SqlVulnerabilityAssessmentScanResultRuleStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("isTrimmed"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isTrimmed = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("queryResults"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<IList<string>> array = new List<IList<string>>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            List<string> array0 = new List<string>();
                            foreach (var item0 in item.EnumerateArray())
                            {
                                array0.Add(item0.GetString());
                            }
                            array.Add(array0);
                        }
                    }
                    queryResults = array;
                    continue;
                }
                if (property.NameEquals("remediation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    remediation = SqlVulnerabilityAssessmentRemediation.DeserializeSqlVulnerabilityAssessmentRemediation(property.Value, options);
                    continue;
                }
                if (property.NameEquals("baselineAdjustedResult"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    baselineAdjustedResult = BaselineAdjustedResult.DeserializeBaselineAdjustedResult(property.Value, options);
                    continue;
                }
                if (property.NameEquals("ruleMetadata"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ruleMetadata = VulnerabilityAssessmentRule.DeserializeVulnerabilityAssessmentRule(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SqlVulnerabilityAssessmentScanResultProperties(
                ruleId,
                status,
                isTrimmed,
                queryResults ?? new ChangeTrackingList<IList<string>>(),
                remediation,
                baselineAdjustedResult,
                ruleMetadata,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SqlVulnerabilityAssessmentScanResultProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanResultProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanResultProperties)} does not support writing '{options.Format}' format.");
            }
        }

        SqlVulnerabilityAssessmentScanResultProperties IPersistableModel<SqlVulnerabilityAssessmentScanResultProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanResultProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSqlVulnerabilityAssessmentScanResultProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanResultProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SqlVulnerabilityAssessmentScanResultProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
