// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> A vulnerability assessment scan record properties. </summary>
    public partial class SqlVulnerabilityAssessmentScanProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentScanProperties"/>. </summary>
        public SqlVulnerabilityAssessmentScanProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentScanProperties"/>. </summary>
        /// <param name="triggerType"> The scan trigger type. </param>
        /// <param name="state"> The scan status. </param>
        /// <param name="server"> The server name. </param>
        /// <param name="database"> The database name. </param>
        /// <param name="sqlVersion"> The SQL version. </param>
        /// <param name="startOn"> The scan start time (UTC). </param>
        /// <param name="endOn"> Scan results are valid until end time (UTC). </param>
        /// <param name="highSeverityFailedRulesCount"> The number of failed rules with high severity. </param>
        /// <param name="mediumSeverityFailedRulesCount"> The number of failed rules with medium severity. </param>
        /// <param name="lowSeverityFailedRulesCount"> The number of failed rules with low severity. </param>
        /// <param name="totalPassedRulesCount"> The number of total passed rules. </param>
        /// <param name="totalFailedRulesCount"> The number of total failed rules. </param>
        /// <param name="totalRulesCount"> The number of total rules assessed. </param>
        /// <param name="isBaselineApplied"> Baseline created for this database, and has one or more rules. </param>
        /// <param name="lastScanOn"> Last scan time. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVulnerabilityAssessmentScanProperties(SqlVulnerabilityAssessmentScanTriggerType? triggerType, SqlVulnerabilityAssessmentScanState? state, string server, string database, string sqlVersion, DateTimeOffset? startOn, DateTimeOffset? endOn, int? highSeverityFailedRulesCount, int? mediumSeverityFailedRulesCount, int? lowSeverityFailedRulesCount, int? totalPassedRulesCount, int? totalFailedRulesCount, int? totalRulesCount, bool? isBaselineApplied, DateTimeOffset? lastScanOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TriggerType = triggerType;
            State = state;
            Server = server;
            Database = database;
            SqlVersion = sqlVersion;
            StartOn = startOn;
            EndOn = endOn;
            HighSeverityFailedRulesCount = highSeverityFailedRulesCount;
            MediumSeverityFailedRulesCount = mediumSeverityFailedRulesCount;
            LowSeverityFailedRulesCount = lowSeverityFailedRulesCount;
            TotalPassedRulesCount = totalPassedRulesCount;
            TotalFailedRulesCount = totalFailedRulesCount;
            TotalRulesCount = totalRulesCount;
            IsBaselineApplied = isBaselineApplied;
            LastScanOn = lastScanOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The scan trigger type. </summary>
        public SqlVulnerabilityAssessmentScanTriggerType? TriggerType { get; set; }
        /// <summary> The scan status. </summary>
        public SqlVulnerabilityAssessmentScanState? State { get; set; }
        /// <summary> The server name. </summary>
        public string Server { get; set; }
        /// <summary> The database name. </summary>
        public string Database { get; set; }
        /// <summary> The SQL version. </summary>
        public string SqlVersion { get; set; }
        /// <summary> The scan start time (UTC). </summary>
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> Scan results are valid until end time (UTC). </summary>
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> The number of failed rules with high severity. </summary>
        public int? HighSeverityFailedRulesCount { get; set; }
        /// <summary> The number of failed rules with medium severity. </summary>
        public int? MediumSeverityFailedRulesCount { get; set; }
        /// <summary> The number of failed rules with low severity. </summary>
        public int? LowSeverityFailedRulesCount { get; set; }
        /// <summary> The number of total passed rules. </summary>
        public int? TotalPassedRulesCount { get; set; }
        /// <summary> The number of total failed rules. </summary>
        public int? TotalFailedRulesCount { get; set; }
        /// <summary> The number of total rules assessed. </summary>
        public int? TotalRulesCount { get; set; }
        /// <summary> Baseline created for this database, and has one or more rules. </summary>
        public bool? IsBaselineApplied { get; set; }
        /// <summary> Last scan time. </summary>
        public DateTimeOffset? LastScanOn { get; set; }
    }
}
