// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class SqlVulnerabilityAssessmentScanProperties : IUtf8JsonSerializable, IJsonModel<SqlVulnerabilityAssessmentScanProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SqlVulnerabilityAssessmentScanProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SqlVulnerabilityAssessmentScanProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(TriggerType))
            {
                writer.WritePropertyName("triggerType"u8);
                writer.WriteStringValue(TriggerType.Value.ToString());
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsDefined(Server))
            {
                writer.WritePropertyName("server"u8);
                writer.WriteStringValue(Server);
            }
            if (Optional.IsDefined(Database))
            {
                writer.WritePropertyName("database"u8);
                writer.WriteStringValue(Database);
            }
            if (Optional.IsDefined(SqlVersion))
            {
                writer.WritePropertyName("sqlVersion"u8);
                writer.WriteStringValue(SqlVersion);
            }
            if (Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startTime"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (Optional.IsDefined(EndOn))
            {
                writer.WritePropertyName("endTime"u8);
                writer.WriteStringValue(EndOn.Value, "O");
            }
            if (Optional.IsDefined(HighSeverityFailedRulesCount))
            {
                writer.WritePropertyName("highSeverityFailedRulesCount"u8);
                writer.WriteNumberValue(HighSeverityFailedRulesCount.Value);
            }
            if (Optional.IsDefined(MediumSeverityFailedRulesCount))
            {
                writer.WritePropertyName("mediumSeverityFailedRulesCount"u8);
                writer.WriteNumberValue(MediumSeverityFailedRulesCount.Value);
            }
            if (Optional.IsDefined(LowSeverityFailedRulesCount))
            {
                writer.WritePropertyName("lowSeverityFailedRulesCount"u8);
                writer.WriteNumberValue(LowSeverityFailedRulesCount.Value);
            }
            if (Optional.IsDefined(TotalPassedRulesCount))
            {
                writer.WritePropertyName("totalPassedRulesCount"u8);
                writer.WriteNumberValue(TotalPassedRulesCount.Value);
            }
            if (Optional.IsDefined(TotalFailedRulesCount))
            {
                writer.WritePropertyName("totalFailedRulesCount"u8);
                writer.WriteNumberValue(TotalFailedRulesCount.Value);
            }
            if (Optional.IsDefined(TotalRulesCount))
            {
                writer.WritePropertyName("totalRulesCount"u8);
                writer.WriteNumberValue(TotalRulesCount.Value);
            }
            if (Optional.IsDefined(IsBaselineApplied))
            {
                writer.WritePropertyName("isBaselineApplied"u8);
                writer.WriteBooleanValue(IsBaselineApplied.Value);
            }
            if (Optional.IsDefined(LastScanOn))
            {
                writer.WritePropertyName("lastScanTime"u8);
                writer.WriteStringValue(LastScanOn.Value, "O");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SqlVulnerabilityAssessmentScanProperties IJsonModel<SqlVulnerabilityAssessmentScanProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSqlVulnerabilityAssessmentScanProperties(document.RootElement, options);
        }

        internal static SqlVulnerabilityAssessmentScanProperties DeserializeSqlVulnerabilityAssessmentScanProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SqlVulnerabilityAssessmentScanTriggerType? triggerType = default;
            SqlVulnerabilityAssessmentScanState? state = default;
            string server = default;
            string database = default;
            string sqlVersion = default;
            DateTimeOffset? startTime = default;
            DateTimeOffset? endTime = default;
            int? highSeverityFailedRulesCount = default;
            int? mediumSeverityFailedRulesCount = default;
            int? lowSeverityFailedRulesCount = default;
            int? totalPassedRulesCount = default;
            int? totalFailedRulesCount = default;
            int? totalRulesCount = default;
            bool? isBaselineApplied = default;
            DateTimeOffset? lastScanTime = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("triggerType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    triggerType = new SqlVulnerabilityAssessmentScanTriggerType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new SqlVulnerabilityAssessmentScanState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("server"u8))
                {
                    server = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("database"u8))
                {
                    database = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sqlVersion"u8))
                {
                    sqlVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("endTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("highSeverityFailedRulesCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    highSeverityFailedRulesCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("mediumSeverityFailedRulesCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    mediumSeverityFailedRulesCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("lowSeverityFailedRulesCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lowSeverityFailedRulesCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalPassedRulesCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalPassedRulesCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalFailedRulesCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalFailedRulesCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalRulesCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalRulesCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("isBaselineApplied"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isBaselineApplied = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("lastScanTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastScanTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SqlVulnerabilityAssessmentScanProperties(
                triggerType,
                state,
                server,
                database,
                sqlVersion,
                startTime,
                endTime,
                highSeverityFailedRulesCount,
                mediumSeverityFailedRulesCount,
                lowSeverityFailedRulesCount,
                totalPassedRulesCount,
                totalFailedRulesCount,
                totalRulesCount,
                isBaselineApplied,
                lastScanTime,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SqlVulnerabilityAssessmentScanProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanProperties)} does not support writing '{options.Format}' format.");
            }
        }

        SqlVulnerabilityAssessmentScanProperties IPersistableModel<SqlVulnerabilityAssessmentScanProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSqlVulnerabilityAssessmentScanProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SqlVulnerabilityAssessmentScanProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
