// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Remediation details. </summary>
    public partial class SqlVulnerabilityAssessmentRemediation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentRemediation"/>. </summary>
        public SqlVulnerabilityAssessmentRemediation()
        {
            Scripts = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentRemediation"/>. </summary>
        /// <param name="description"> Remediation description. </param>
        /// <param name="scripts"> Remediation script. </param>
        /// <param name="isAutomated"> Is remediation automated. </param>
        /// <param name="portalLink"> Optional link to remediate in Azure Portal. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVulnerabilityAssessmentRemediation(string description, IList<string> scripts, bool? isAutomated, string portalLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Description = description;
            Scripts = scripts;
            IsAutomated = isAutomated;
            PortalLink = portalLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Remediation description. </summary>
        public string Description { get; set; }
        /// <summary> Remediation script. </summary>
        public IList<string> Scripts { get; }
        /// <summary> Is remediation automated. </summary>
        public bool? IsAutomated { get; set; }
        /// <summary> Optional link to remediate in Azure Portal. </summary>
        public string PortalLink { get; set; }
    }
}
