// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    public partial class SqlVulnerabilityAssessmentRemediation : IUtf8JsonSerializable, IJsonModel<SqlVulnerabilityAssessmentRemediation>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SqlVulnerabilityAssessmentRemediation>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SqlVulnerabilityAssessmentRemediation>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentRemediation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentRemediation)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsCollectionDefined(Scripts))
            {
                writer.WritePropertyName("scripts"u8);
                writer.WriteStartArray();
                foreach (var item in Scripts)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsAutomated))
            {
                writer.WritePropertyName("automated"u8);
                writer.WriteBooleanValue(IsAutomated.Value);
            }
            if (Optional.IsDefined(PortalLink))
            {
                writer.WritePropertyName("portalLink"u8);
                writer.WriteStringValue(PortalLink);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SqlVulnerabilityAssessmentRemediation IJsonModel<SqlVulnerabilityAssessmentRemediation>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentRemediation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentRemediation)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSqlVulnerabilityAssessmentRemediation(document.RootElement, options);
        }

        internal static SqlVulnerabilityAssessmentRemediation DeserializeSqlVulnerabilityAssessmentRemediation(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string description = default;
            IList<string> scripts = default;
            bool? automated = default;
            string portalLink = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("scripts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    scripts = array;
                    continue;
                }
                if (property.NameEquals("automated"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    automated = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("portalLink"u8))
                {
                    portalLink = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SqlVulnerabilityAssessmentRemediation(description, scripts ?? new ChangeTrackingList<string>(), automated, portalLink, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SqlVulnerabilityAssessmentRemediation>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentRemediation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentRemediation)} does not support writing '{options.Format}' format.");
            }
        }

        SqlVulnerabilityAssessmentRemediation IPersistableModel<SqlVulnerabilityAssessmentRemediation>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentRemediation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSqlVulnerabilityAssessmentRemediation(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentRemediation)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SqlVulnerabilityAssessmentRemediation>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
