// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Details of the resource that was assessed. </summary>
    public partial class SqlServerVulnerabilityProperties : SecuritySubAssessmentAdditionalInfo
    {
        /// <summary> Initializes a new instance of <see cref="SqlServerVulnerabilityProperties"/>. </summary>
        public SqlServerVulnerabilityProperties()
        {
            AssessedResourceType = AssessedResourceType.SqlServerVulnerability;
        }

        /// <summary> Initializes a new instance of <see cref="SqlServerVulnerabilityProperties"/>. </summary>
        /// <param name="assessedResourceType"> Sub-assessment resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="sqlServerVulnerabilityType"> The resource type the sub assessment refers to in its resource details. </param>
        /// <param name="query"> The T-SQL query that runs on your SQL database to perform the particular check. </param>
        internal SqlServerVulnerabilityProperties(AssessedResourceType assessedResourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string sqlServerVulnerabilityType, string query) : base(assessedResourceType, serializedAdditionalRawData)
        {
            SqlServerVulnerabilityType = sqlServerVulnerabilityType;
            Query = query;
            AssessedResourceType = assessedResourceType;
        }

        /// <summary> The resource type the sub assessment refers to in its resource details. </summary>
        public string SqlServerVulnerabilityType { get; }
        /// <summary> The T-SQL query that runs on your SQL database to perform the particular check. </summary>
        public string Query { get; }
    }
}
