// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityCenter.Models
{
    /// <summary> Additional context fields for server vulnerability assessment. </summary>
    public partial class ServerVulnerabilityProperties : SecuritySubAssessmentAdditionalInfo
    {
        /// <summary> Initializes a new instance of <see cref="ServerVulnerabilityProperties"/>. </summary>
        public ServerVulnerabilityProperties()
        {
            Cvss = new ChangeTrackingDictionary<string, SecurityCvss>();
            Cve = new ChangeTrackingList<SecurityCve>();
            VendorReferences = new ChangeTrackingList<VendorReference>();
            AssessedResourceType = new AssessedResourceType("ServerVulnerabilityAssessment");
        }

        /// <summary> Initializes a new instance of <see cref="ServerVulnerabilityProperties"/>. </summary>
        /// <param name="assessedResourceType"> Sub-assessment resource type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="serverVulnerabilityType"> Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered. </param>
        /// <param name="cvss"> Dictionary from cvss version to cvss details object. </param>
        /// <param name="isPatchable"> Indicates whether a patch is available or not. </param>
        /// <param name="cve"> List of CVEs. </param>
        /// <param name="threat"> Threat name. </param>
        /// <param name="publishedOn"> Published time. </param>
        /// <param name="vendorReferences"></param>
        internal ServerVulnerabilityProperties(AssessedResourceType assessedResourceType, IDictionary<string, BinaryData> serializedAdditionalRawData, string serverVulnerabilityType, IReadOnlyDictionary<string, SecurityCvss> cvss, bool? isPatchable, IReadOnlyList<SecurityCve> cve, string threat, DateTimeOffset? publishedOn, IReadOnlyList<VendorReference> vendorReferences) : base(assessedResourceType, serializedAdditionalRawData)
        {
            ServerVulnerabilityType = serverVulnerabilityType;
            Cvss = cvss;
            IsPatchable = isPatchable;
            Cve = cve;
            Threat = threat;
            PublishedOn = publishedOn;
            VendorReferences = vendorReferences;
            AssessedResourceType = assessedResourceType;
        }

        /// <summary> Vulnerability Type. e.g: Vulnerability, Potential Vulnerability, Information Gathered. </summary>
        public string ServerVulnerabilityType { get; }
        /// <summary> Dictionary from cvss version to cvss details object. </summary>
        public IReadOnlyDictionary<string, SecurityCvss> Cvss { get; }
        /// <summary> Indicates whether a patch is available or not. </summary>
        public bool? IsPatchable { get; }
        /// <summary> List of CVEs. </summary>
        public IReadOnlyList<SecurityCve> Cve { get; }
        /// <summary> Threat name. </summary>
        public string Threat { get; }
        /// <summary> Published time. </summary>
        public DateTimeOffset? PublishedOn { get; }
        /// <summary> Gets the vendor references. </summary>
        public IReadOnlyList<VendorReference> VendorReferences { get; }
    }
}
